/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junitassertj;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openrewrite.AutoConfigure;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodTypeBuilder;
import org.openrewrite.java.tree.TypeUtils;

@AutoConfigure
public class AssertNotNullToAssertThat
extends JavaIsoRefactorVisitor {
    private static final String JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME = "org.junit.jupiter.api.Assertions";
    private static final String ASSERTJ_QUALIFIED_ASSERTIONS_CLASS_NAME = "org.assertj.core.api.Assertions";
    private static final String ASSERTJ_ASSERT_THAT_METHOD_NAME = "assertThat";
    private static final MethodMatcher JUNIT_ASSERT_NOT_NULL_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertNotNull(..)");
    private static final JavaType.Method assertThatMethodType = MethodTypeBuilder.newMethodType().declaringClass("org.assertj.core.api.Assertions").flags(new Flag[]{Flag.Public, Flag.Static}).returnType("org.assertj.core.api.AbstractBooleanAssert").name("assertThat").parameter((JavaType)JavaType.Primitive.Boolean, "arg1").build();

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation original = super.visitMethodInvocation(method);
        if (!JUNIT_ASSERT_NOT_NULL_MATCHER.matches(method)) {
            return original;
        }
        List originalArgs = original.getArgs().getArgs();
        Expression objToCheck = (Expression)originalArgs.get(0);
        Expression message = originalArgs.size() == 2 ? (Expression)originalArgs.get(1) : null;
        J.MethodInvocation assertSelect = new J.MethodInvocation(Tree.randomId(), null, null, J.Ident.build((UUID)Tree.randomId(), (String)ASSERTJ_ASSERT_THAT_METHOD_NAME, (JavaType)JavaType.Primitive.Void, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.singletonList(objToCheck), Formatting.EMPTY), assertThatMethodType, Formatting.EMPTY);
        if (message != null) {
            String messageAs = TypeUtils.isString((JavaType)message.getType()) ? "as" : "withFailMessage";
            assertSelect = new J.MethodInvocation(Tree.randomId(), (Expression)assertSelect, null, J.Ident.build((UUID)Tree.randomId(), (String)messageAs, null, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.singletonList((Expression)message.withPrefix("")), Formatting.EMPTY), null, Formatting.EMPTY);
        }
        J.MethodInvocation replacement = new J.MethodInvocation(Tree.randomId(), (Expression)assertSelect, null, J.Ident.build((UUID)Tree.randomId(), (String)"isNotNull", (JavaType)JavaType.Primitive.Boolean, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), Collections.emptyList(), Formatting.EMPTY), null, Formatting.format((String)"\n"));
        this.maybeRemoveImport(JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME);
        this.maybeAddImport(ASSERTJ_QUALIFIED_ASSERTIONS_CLASS_NAME, ASSERTJ_ASSERT_THAT_METHOD_NAME);
        this.andThen((RefactorVisitor)new AutoFormat(new J[]{replacement}));
        return replacement;
    }
}

