/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junitassertj;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.openrewrite.Formatting;
import org.openrewrite.RefactorVisitor;
import org.openrewrite.Tree;
import org.openrewrite.java.AutoFormat;
import org.openrewrite.java.JavaIsoRefactorVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodTypeBuilder;

public class JUnitFailToAssertJFail
extends JavaIsoRefactorVisitor {
    private static final String JUNIT_QUALIFIED_ASSERTIONS_CLASS_NAME = "org.junit.jupiter.api.Assertions";
    private static final String ASSERTJ_QUALIFIED_ASSERTIONS_CLASS_NAME = "org.assertj.core.api.Assertions";
    private static final MethodMatcher JUNIT_FAIL_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions fail(..)");

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method) {
        J.MethodInvocation original = method;
        if (!JUNIT_FAIL_MATCHER.matches(method)) {
            return original;
        }
        MethodTypeBuilder methodTypeBuilder = MethodTypeBuilder.newMethodType().declaringClass(ASSERTJ_QUALIFIED_ASSERTIONS_CLASS_NAME).flags(new Flag[]{Flag.Public, Flag.Static}).returnType((JavaType)JavaType.Class.build((String)"java.lang.Object"), (JavaType)new JavaType.GenericTypeVariable("T", JavaType.Class.build((String)"java.lang.Object"))).name("fail");
        List originalArgs = original.getArgs().getArgs();
        ArrayList<Object> newArgs = new ArrayList<Object>();
        if (originalArgs.get(0) instanceof J.Literal) {
            newArgs.add((Expression)originalArgs.get(0));
            methodTypeBuilder.parameter((JavaType)JavaType.Class.build((String)"java.lang.String"), "failureMessage");
            if (originalArgs.size() == 2) {
                newArgs.add((Expression)originalArgs.get(1));
            }
        } else if (originalArgs.get(0) instanceof J.Empty) {
            newArgs.add(J.Literal.buildString((String)""));
        } else {
            methodTypeBuilder.parameter((JavaType)JavaType.Class.build((String)"java.lang.String"), "failureMessage");
            methodTypeBuilder.parameter("java.lang.Throwable", "realCause");
            newArgs.add(J.Literal.buildString((String)""));
            newArgs.add((Expression)originalArgs.get(0));
        }
        JavaType.Method assertJFailMethodType = methodTypeBuilder.build();
        J.MethodInvocation assertJFail = new J.MethodInvocation(Tree.randomId(), null, null, J.Ident.build((UUID)Tree.randomId(), (String)"fail", (JavaType)JavaType.Primitive.Void, (Formatting)Formatting.EMPTY), new J.MethodInvocation.Arguments(Tree.randomId(), newArgs, Formatting.EMPTY), assertJFailMethodType, Formatting.format((String)"\n"));
        this.maybeAddImport(ASSERTJ_QUALIFIED_ASSERTIONS_CLASS_NAME, "fail");
        this.andThen((RefactorVisitor)new RemoveUnusedImports());
        this.andThen((RefactorVisitor)new AutoFormat(new J[]{assertJFail}));
        return assertJFail;
    }
}

