/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class JUnitAssertTrueToAssertThat
extends Recipe {
    public String getDisplayName() {
        return "JUnit `assertTrue` to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertTrue()` to AssertJ's `assertThat().isTrue()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.jupiter.api.Assertions");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AssertTrueToAssertThatVisitor();
    }

    public static class AssertTrueToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Supplier<JavaParser> ASSERTJ_JAVA_PARSER = () -> JavaParser.fromJavaVersion().classpath(new String[]{"assertj-core"}).build();
        private static final MethodMatcher JUNIT_ASSERT_TRUE = new MethodMatcher("org.junit.jupiter.api.Assertions assertTrue(boolean, ..)");

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_TRUE.matches(method)) {
                return method;
            }
            List args = method.getArguments();
            Expression actual = (Expression)args.get(0);
            if (args.size() == 1) {
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertTrueToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any(boolean)}).isTrue();").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.ASSERTJ_JAVA_PARSER).build(), method.getCoordinates().replace(), new Object[]{actual});
            } else {
                Expression message = (Expression)args.get(1);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder(() -> ((AssertTrueToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any(boolean)}).as(#{any(String)}).isTrue();") : JavaTemplate.builder(() -> ((AssertTrueToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any(boolean)}).as(#{any(java.util.function.Supplier)}).isTrue();");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.ASSERTJ_JAVA_PARSER).build(), method.getCoordinates().replace(), new Object[]{actual, message});
            }
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
            return method;
        }
    }
}

