/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class AssertFalseEqualsToAssertNotEquals
extends Recipe {
    private static final MethodMatcher ASSERT_FALSE = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(..)");

    public String getDisplayName() {
        return "Replace JUnit `assertFalse(a.equals(b))` to `assertNotEquals(a,b)`";
    }

    public String getDescription() {
        return "Using `assertNotEquals(a,b)` is simpler and more clear.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod(ASSERT_FALSE);
    }

    protected JavaVisitor<ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final Supplier<JavaParser> javaParser = () -> JavaParser.fromJavaVersion().classpath(new String[]{"junit-jupiter-api"}).build();

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_FALSE.matches(method) && this.isEquals((Expression)method.getArguments().get(0))) {
                    Object[] objectArray;
                    StringBuilder sb = new StringBuilder();
                    if (mi.getSelect() == null) {
                        this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", "assertNotEquals");
                    } else {
                        sb.append("Assertions.");
                    }
                    sb.append("assertNotEquals(#{any(java.lang.Object)}, #{any(java.lang.Object)}");
                    if (mi.getArguments().size() == 2) {
                        sb.append(", #{any()}");
                    }
                    sb.append(")");
                    J.MethodInvocation methodInvocation = this.getMethodInvocation((Expression)method);
                    J.MethodInvocation s = (J.MethodInvocation)methodInvocation.getArguments().get(0);
                    if (method.getArguments().size() == 2) {
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = s.getSelect();
                        objectArray2[1] = s.getArguments().get(0);
                        objectArray = objectArray2;
                        objectArray2[2] = mi.getArguments().get(1);
                    } else {
                        Object[] objectArray3 = new Object[2];
                        objectArray3[0] = s.getSelect();
                        objectArray = objectArray3;
                        objectArray3[1] = s.getArguments().get(0);
                    }
                    Object[] args = objectArray;
                    JavaTemplate t = mi.getSelect() == null ? JavaTemplate.builder(() -> (this).getCursor(), (String)sb.toString()).staticImports(new String[]{"org.junit.jupiter.api.Assertions.assertNotEquals"}).javaParser(this.javaParser).build() : JavaTemplate.builder(() -> (this).getCursor(), (String)sb.toString()).imports(new String[]{"org.junit.jupiter.api.Assertions"}).javaParser(this.javaParser).build();
                    return mi.withTemplate((SourceTemplate)t, mi.getCoordinates().replace(), args);
                }
                return mi;
            }

            private J.MethodInvocation getMethodInvocation(Expression expr) {
                List s = expr.getSideEffects();
                return (J.MethodInvocation)s.get(0);
            }

            private boolean isEquals(Expression expr) {
                List s = expr.getSideEffects();
                if (s.isEmpty()) {
                    return false;
                }
                J.MethodInvocation methodInvocation = this.getMethodInvocation(expr);
                return "equals".equals(methodInvocation.getName().getSimpleName());
            }
        };
    }
}

