/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cucumber;

import java.text.RuleBasedCollator;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class CucumberAnnotationToSuite
extends Recipe {
    private static final String IO_CUCUMBER_JUNIT_PLATFORM_ENGINE_CUCUMBER = "io.cucumber.junit.platform.engine.Cucumber";
    private static final String SUITE = "org.junit.platform.suite.api.Suite";
    private static final String SELECT_CLASSPATH_RESOURCE = "org.junit.platform.suite.api.SelectClasspathResource";

    public String getDisplayName() {
        return "Replace @Cucumber with @Suite";
    }

    public String getDescription() {
        return "Replace @Cucumber with @Suite and @SelectClasspathResource(\"cucumber/annotated/class/package\").";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(2L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType(IO_CUCUMBER_JUNIT_PLATFORM_ENGINE_CUCUMBER);
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        final AnnotationMatcher cucumberAnnoMatcher = new AnnotationMatcher("@io.cucumber.junit.platform.engine.Cucumber");
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext p) {
                J.ClassDeclaration classDecl = super.visitClassDeclaration(cd, (Object)p);
                if (classDecl.getAllAnnotations().stream().noneMatch(arg_0 -> ((AnnotationMatcher)cucumberAnnoMatcher).matches(arg_0))) {
                    return classDecl;
                }
                Supplier<JavaParser> javaParserSupplier = () -> JavaParser.fromJavaVersion().classpath(new String[]{"junit-platform-suite-api"}).build();
                JavaType.FullyQualified classFqn = TypeUtils.asFullyQualified((JavaType)classDecl.getType());
                if (classFqn != null) {
                    this.maybeRemoveImport(CucumberAnnotationToSuite.IO_CUCUMBER_JUNIT_PLATFORM_ENGINE_CUCUMBER);
                    this.maybeAddImport(CucumberAnnotationToSuite.SUITE);
                    this.maybeAddImport(CucumberAnnotationToSuite.SELECT_CLASSPATH_RESOURCE);
                    String classDeclPath = classFqn.getPackageName().replace('.', '/');
                    classDecl = classDecl.withLeadingAnnotations(ListUtils.map((List)classDecl.getLeadingAnnotations(), ann -> {
                        if (cucumberAnnoMatcher.matches(ann)) {
                            String code = "@SelectClasspathResource(\"#{}\")";
                            JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), (String)code).javaParser(javaParserSupplier).imports(new String[]{CucumberAnnotationToSuite.SELECT_CLASSPATH_RESOURCE}).build();
                            return (J.Annotation)ann.withTemplate((SourceTemplate)template, ann.getCoordinates().replace(), new Object[]{classDeclPath});
                        }
                        return ann;
                    }));
                    classDecl = (J.ClassDeclaration)classDecl.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"@Suite").javaParser(javaParserSupplier).imports(new String[]{CucumberAnnotationToSuite.SUITE}).build(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName, new RuleBasedCollator("< SelectClasspathResource"))), new Object[0]);
                }
                return classDecl;
            }
        };
    }
}

