/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class TemporaryFolderToTempDir
extends Recipe {
    public String getDisplayName() {
        return "Use JUnit Jupiter `@TempDir`";
    }

    public String getDescription() {
        return "Translates JUnit4's `org.junit.rules.TemporaryFolder` into JUnit 5's `org.junit.jupiter.api.io.TempDir`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.rules.TemporaryFolder");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final AnnotationMatcher classRule = new AnnotationMatcher("@org.junit.ClassRule");
        final AnnotationMatcher rule = new AnnotationMatcher("@org.junit.Rule");
        final Supplier<JavaParser> tempdirParser = () -> JavaParser.fromJavaVersion().dependsOn(Collections.singletonList(Parser.Input.fromString((String)"package org.junit.jupiter.api.io;\npublic @interface TempDir {}"))).build();
        return new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                J.CompilationUnit c = (J.CompilationUnit)super.visitCompilationUnit(cu, (Object)executionContext);
                if (c != cu) {
                    this.doAfterVisit((Recipe)new ChangeType("org.junit.rules.TemporaryFolder", "java.io.File", Boolean.valueOf(true)));
                    this.maybeAddImport("java.io.File");
                    this.maybeAddImport("org.junit.jupiter.api.io.TempDir");
                    this.maybeRemoveImport("org.junit.ClassRule");
                    this.maybeRemoveImport("org.junit.Rule");
                    this.maybeRemoveImport("org.junit.rules.TemporaryFolder");
                }
                return c;
            }

            public J visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                J.VariableDeclarations mv = (J.VariableDeclarations)super.visitVariableDeclarations(multiVariable, (Object)executionContext);
                if (!this.isRuleAnnotatedTemporaryFolder(mv)) {
                    return mv;
                }
                String fieldVars = mv.getVariables().stream().map(fv -> fv.withInitializer(null)).map(J::print).collect(Collectors.joining(","));
                String modifiers = mv.getModifiers().stream().map(it -> it.getType().name().toLowerCase()).collect(Collectors.joining(" "));
                mv = (J.VariableDeclarations)mv.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"@TempDir\n#{} File#{};").imports(new String[]{"java.io.File", "org.junit.jupiter.api.io.TempDir"}).javaParser(tempdirParser).build(), mv.getCoordinates().replace(), new Object[]{modifiers, fieldVars});
                return mv;
            }

            private boolean isRuleAnnotatedTemporaryFolder(J.VariableDeclarations vd) {
                return TypeUtils.isOfClassType((JavaType)vd.getTypeAsFullyQualified(), (String)"org.junit.rules.TemporaryFolder") && vd.getLeadingAnnotations().stream().anyMatch(anno -> classRule.matches(anno) || rule.matches(anno));
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
                if (mi.getSelect() != null && mi.getMethodType() != null && TypeUtils.isOfClassType((JavaType)mi.getMethodType().getDeclaringType(), (String)"org.junit.rules.TemporaryFolder")) {
                    switch (mi.getSimpleName()) {
                        case "newFile": {
                            return this.convertToNewFile(mi);
                        }
                        case "newFolder": {
                            this.doAfterVisit((TreeVisitor)new AddNewFolderMethod(mi));
                            break;
                        }
                        case "create": {
                            return null;
                        }
                        case "getRoot": {
                            return mi.getSelect().withPrefix(mi.getPrefix());
                        }
                        default: {
                            return mi;
                        }
                    }
                }
                return mi;
            }

            private J convertToNewFile(J.MethodInvocation mi) {
                if (mi.getSelect() == null) {
                    return mi;
                }
                J tempDir = mi.getSelect().withType((JavaType)JavaType.ShallowClass.build((String)"java.io.File"));
                List args = mi.getArguments().stream().filter(arg -> !(arg instanceof J.Empty)).collect(Collectors.toList());
                if (args.isEmpty()) {
                    return mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"File.createTempFile(\"junit\", null, #{any(java.io.File)})").imports(new String[]{"java.io.File"}).javaParser(tempdirParser).build(), mi.getCoordinates().replace(), new Object[]{tempDir});
                }
                return mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"File.createTempFile(#{any(java.lang.String)}, null, #{any(java.io.File)})").imports(new String[]{"java.io.File"}).javaParser(tempdirParser).build(), mi.getCoordinates().replace(), new Object[]{args.get(0), tempDir});
            }
        };
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    private static class AddNewFolderMethod
    extends JavaIsoVisitor<ExecutionContext> {
        private final J.MethodInvocation methodInvocation;
        private final Supplier<JavaParser> tempdirParser = () -> JavaParser.fromJavaVersion().dependsOn(Collections.singletonList(Parser.Input.fromString((String)"package org.junit.jupiter.api.io;\npublic @interface TempDir {}"))).build();

        public AddNewFolderMethod(J.MethodInvocation methodInvocation) {
            this.methodInvocation = methodInvocation;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            Stream<J.MethodDeclaration> methods = cd.getBody().getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(J.MethodDeclaration.class::cast);
            JavaType.Method newFolderMethodDeclaration = methods.filter(m -> {
                List params = m.getParameters();
                return "newFolder".equals(m.getSimpleName()) && params.size() == 2 && ((Statement)params.get(0)).hasClassType((JavaType.Class)JavaType.ShallowClass.build((String)"java.io.File")) && ((Statement)params.get(1)).hasClassType((JavaType.Class)JavaType.ShallowClass.build((String)"java.lang.String"));
            }).map(J.MethodDeclaration::getMethodType).filter(Objects::nonNull).findAny().orElse(null);
            if (newFolderMethodDeclaration == null) {
                cd = (J.ClassDeclaration)cd.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AddNewFolderMethod)this).getCursor(), (String)"private static File newFolder(File root, String... subDirs) throws IOException {\n    String subFolder = String.join(\"/\", subDirs);\n    File result = new File(root, subFolder);\n    if(!result.mkdirs()) {\n        throw new IOException(\"Couldn't create folders \" + root);\n    }\n    return result;\n}").imports(new String[]{"java.io.File", "java.io.IOException"}).javaParser(this.tempdirParser).build(), cd.getBody().getCoordinates().lastStatement(), new Object[0]);
                newFolderMethodDeclaration = ((J.MethodDeclaration)cd.getBody().getStatements().get(cd.getBody().getStatements().size() - 1)).getMethodType();
                this.maybeAddImport("java.io.File");
                this.maybeAddImport("java.io.IOException");
            }
            assert (newFolderMethodDeclaration != null);
            this.doAfterVisit((TreeVisitor)new TranslateNewFolderMethodInvocation(this.methodInvocation, newFolderMethodDeclaration));
            return cd;
        }

        private static class TranslateNewFolderMethodInvocation
        extends JavaVisitor<ExecutionContext> {
            J.MethodInvocation methodScope;
            JavaType.Method newMethodType;
            private final Supplier<JavaParser> tempdirParser = () -> JavaParser.fromJavaVersion().dependsOn(Collections.singletonList(Parser.Input.fromString((String)"package org.junit.jupiter.api.io;\npublic @interface TempDir {}"))).build();

            public TranslateNewFolderMethodInvocation(J.MethodInvocation method, JavaType.Method newMethodType) {
                this.methodScope = method;
                this.newMethodType = newMethodType;
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                if (!method.isScope((Tree)this.methodScope)) {
                    return method;
                }
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)executionContext);
                if (mi.getSelect() != null) {
                    J tempDir = mi.getSelect().withType((JavaType)JavaType.ShallowClass.build((String)"java.io.File"));
                    List<Expression> args = mi.getArguments().stream().filter(arg -> !(arg instanceof J.Empty)).collect(Collectors.toList());
                    if (args.isEmpty()) {
                        mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((TranslateNewFolderMethodInvocation)this).getCursor(), (String)"newFolder(#{any(java.io.File)}, \"junit\")").imports(new String[]{"java.io.File"}).javaParser(this.tempdirParser).build(), mi.getCoordinates().replace(), new Object[]{tempDir});
                    } else if (args.size() == 1) {
                        mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((TranslateNewFolderMethodInvocation)this).getCursor(), (String)"newFolder(#{any(java.io.File)}, #{any(java.lang.String)})").imports(new String[]{"java.io.File"}).javaParser(this.tempdirParser).build(), mi.getCoordinates().replace(), new Object[]{tempDir, args.get(0)});
                    } else {
                        StringBuilder sb = new StringBuilder("newFolder(#{any(java.io.File)}");
                        args.forEach(arg -> sb.append(", #{any(java.lang.String)}"));
                        sb.append(")");
                        ArrayList templateArgs = new ArrayList(args);
                        templateArgs.add(0, tempDir);
                        mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((TranslateNewFolderMethodInvocation)this).getCursor(), (String)sb.toString()).imports(new String[]{"java.io.File"}).javaParser(this.tempdirParser).build(), mi.getCoordinates().replace(), templateArgs.toArray());
                    }
                    mi = mi.withMethodType(this.newMethodType);
                    J.ClassDeclaration parentClass = (J.ClassDeclaration)this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).getValue();
                    mi = mi.withName(mi.getName().withType((JavaType)parentClass.getType()));
                }
                return mi;
            }
        }
    }
}

