/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Arrays;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class UseTestMethodOrder
extends Recipe {
    public String getDisplayName() {
        return "Migrate from JUnit4 `@FixedMethodOrder` to JUnit5 `@TestMethodOrder`";
    }

    public String getDescription() {
        return "JUnit optionally allows test method execution order to be specified. This Recipe replaces JUnit4 test execution ordering annotations with JUnit5 replacements.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.FixMethodOrder");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private final JavaTemplate testMethodOrder = JavaTemplate.builder(() -> (this).getCursor(), (String)"@TestMethodOrder(MethodName.class)").javaParser(() -> JavaParser.fromJavaVersion().dependsOn(Arrays.asList(Parser.Input.fromString((String)"package org.junit.jupiter.api;\npublic interface MethodOrderer {\n  public class MethodName {}\n}"), Parser.Input.fromString((String)"package org.junit.jupiter.api;\npublic @interface TestMethodOrder {}"))).build()).imports(new String[]{"org.junit.jupiter.api.TestMethodOrder", "org.junit.jupiter.api.MethodOrderer.*"}).build();

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration c = classDecl;
                Set methodOrders = FindAnnotations.find((J)c.withBody(null), (String)"@org.junit.FixMethodOrder");
                if (!methodOrders.isEmpty()) {
                    this.maybeAddImport("org.junit.jupiter.api.TestMethodOrder");
                    this.maybeRemoveImport("org.junit.FixMethodOrder");
                    this.maybeRemoveImport("org.junit.runners.MethodSorters");
                    c = (J.ClassDeclaration)c.withTemplate((SourceTemplate)this.testMethodOrder, ((J.Annotation)methodOrders.iterator().next()).getCoordinates().replace(), new Object[0]);
                    this.maybeAddImport("org.junit.jupiter.api.MethodOrderer.MethodName");
                }
                return super.visitClassDeclaration(c, (Object)ctx);
            }
        };
    }
}

