/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class JUnitAssertFalseToAssertThat
extends Recipe {
    public String getDisplayName() {
        return "JUnit `assertFalse` to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `assertFalse()` to AssertJ's `assertThat().isFalse()`.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.jupiter.api.Assertions");
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AssertFalseToAssertThatVisitor();
    }

    public static class AssertFalseToAssertThatVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Supplier<JavaParser> assertionsParser;
        private static final MethodMatcher JUNIT_ASSERT_FALSE = new MethodMatcher("org.junit.jupiter.api.Assertions assertFalse(boolean, ..)");

        private Supplier<JavaParser> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24.2"}).build();
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            if (!JUNIT_ASSERT_FALSE.matches(method)) {
                return method;
            }
            List args = method.getArguments();
            Expression actual = (Expression)args.get(0);
            if (args.size() == 1) {
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertFalseToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any(boolean)}).isFalse();").staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual});
            } else {
                Expression message = (Expression)args.get(1);
                JavaTemplate.Builder template = TypeUtils.isString((JavaType)message.getType()) ? JavaTemplate.builder(() -> ((AssertFalseToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any(boolean)}).as(#{any(String)}).isFalse();") : JavaTemplate.builder(() -> ((AssertFalseToAssertThatVisitor)this).getCursor(), (String)"assertThat(#{any(boolean)}).as(#{any(java.util.function.Supplier)}).isFalse();");
                method = (J.MethodInvocation)method.withTemplate((SourceTemplate)template.staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).javaParser(this.assertionsParser(ctx)).build(), method.getCoordinates().replace(), new Object[]{actual, message});
            }
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
            return method;
        }
    }
}

