/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.time.Duration;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.template.SourceTemplate;

public class JUnitAssertThrowsToAssertExceptionType
extends Recipe {
    public String getDisplayName() {
        return "JUnit AssertThrows to AssertJ exceptionType";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public String getDescription() {
        return "Convert `JUnit#AssertThrows` to `AssertJ#assertThatExceptionOfType` to allow for chained assertions on the thrown exception.";
    }

    protected UsesMethod<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesMethod("org.junit.jupiter.api.Assertions assertThrows(..)");
    }

    protected AssertExceptionTypeVisitor getVisitor() {
        return new AssertExceptionTypeVisitor();
    }

    private static class AssertExceptionTypeVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private Supplier<JavaParser> assertionsParser;
        private static final MethodMatcher ASSERT_THROWS_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions assertThrows(..)");

        private AssertExceptionTypeVisitor() {
        }

        private Supplier<JavaParser> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24.2"}).build();
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (ASSERT_THROWS_MATCHER.matches(mi) && mi.getArguments().size() == 2) {
                J.Lambda lambdaArg = (J.Lambda)mi.getArguments().get(1);
                lambdaArg = lambdaArg.withType(JavaType.buildType((String)"org.assertj.core.api.ThrowableAssert.ThrowingCallable"));
                mi = (J.MethodInvocation)mi.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((AssertExceptionTypeVisitor)this).getCursor(), (String)"assertThatExceptionOfType(#{any(java.lang.Class)}).isThrownBy(#{any(org.assertj.core.api.ThrowableAssert.ThrowingCallable)})").javaParser(this.assertionsParser(ctx)).staticImports(new String[]{"org.assertj.core.api.AssertionsForClassTypes.assertThatExceptionOfType"}).build(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0), lambdaArg});
                this.maybeAddImport("org.assertj.core.api.AssertionsForClassTypes", "assertThatExceptionOfType");
                this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertThrows");
            }
            return mi;
        }
    }
}

