/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cucumber;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.cleanup.RemoveUnneededBlock;
import org.openrewrite.java.cleanup.UnnecessaryThrows;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

class CucumberJava8ClassVisitor
extends JavaIsoVisitor<ExecutionContext> {
    private static final String IO_CUCUMBER_JAVA = "io.cucumber.java";
    private static final String IO_CUCUMBER_JAVA8 = "io.cucumber.java8";
    private final JavaType.FullyQualified stepDefinitionsClass;
    private final String replacementImport;
    private final String template;
    private final Object[] templateParameters;

    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration cd, ExecutionContext ctx) {
        J.ClassDeclaration classDeclaration = super.visitClassDeclaration(cd, (Object)ctx);
        if (!TypeUtils.isOfType((JavaType)classDeclaration.getType(), (JavaType)this.stepDefinitionsClass)) {
            return classDeclaration;
        }
        List<TypeTree> retained = this.filterImplementingInterfaces(classDeclaration);
        this.maybeAddImport(this.replacementImport);
        this.doAfterVisit((TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration md, ExecutionContext p) {
                J.MethodDeclaration methodDeclaration = super.visitMethodDeclaration(md, (Object)p);
                if (methodDeclaration.isConstructor() && (methodDeclaration.getBody() == null || methodDeclaration.getBody().getStatements().isEmpty())) {
                    return null;
                }
                return methodDeclaration;
            }
        });
        this.doAfterVisit((Recipe)new RemoveUnneededBlock());
        this.doAfterVisit((Recipe)new UnnecessaryThrows());
        return (J.ClassDeclaration)classDeclaration.withImplements(retained).withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((CucumberJava8ClassVisitor)this).getCursor(), (String)this.template).javaParser(() -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"cucumber-java-7.+", "cucumber-java8-7.+"}).build()).imports(new String[]{this.replacementImport}).build(), CucumberJava8ClassVisitor.coordinatesForNewMethod(classDeclaration.getBody()), this.templateParameters);
    }

    private List<TypeTree> filterImplementingInterfaces(J.ClassDeclaration classDeclaration) {
        ArrayList<TypeTree> retained = new ArrayList<TypeTree>();
        for (TypeTree typeTree : Optional.ofNullable(classDeclaration.getImplements()).orElse(Collections.emptyList())) {
            JavaType.Class clazz;
            if (typeTree.getType() instanceof JavaType.Class && IO_CUCUMBER_JAVA8.equals((clazz = (JavaType.Class)typeTree.getType()).getPackageName())) {
                this.maybeRemoveImport(clazz.getFullyQualifiedName());
                continue;
            }
            retained.add(typeTree);
        }
        return retained;
    }

    private static JavaCoordinates coordinatesForNewMethod(J.Block body) {
        return body.getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(firstMethod -> (J.MethodDeclaration)firstMethod).filter(method -> method.getAllAnnotations().stream().anyMatch(ann -> ann.getAnnotationType().getType() != null && ((JavaType.Class)ann.getAnnotationType().getType()).getPackageName().startsWith(IO_CUCUMBER_JAVA))).map(method -> method.getCoordinates().after()).reduce((a, b) -> b).orElseGet(() -> body.getStatements().stream().filter(J.MethodDeclaration.class::isInstance).map(firstMethod -> (J.MethodDeclaration)firstMethod).filter(J.MethodDeclaration::isConstructor).map(constructor -> constructor.getCoordinates().after()).reduce((a, b) -> b).orElseGet(() -> body.getCoordinates().lastStatement()));
    }

    @ConstructorProperties(value={"stepDefinitionsClass", "replacementImport", "template", "templateParameters"})
    public CucumberJava8ClassVisitor(JavaType.FullyQualified stepDefinitionsClass, String replacementImport, String template, Object[] templateParameters) {
        this.stepDefinitionsClass = stepDefinitionsClass;
        this.replacementImport = replacementImport;
        this.template = template;
        this.templateParameters = templateParameters;
    }
}

