/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cucumber;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class RegexToCucumberExpression
extends Recipe {
    private static final String IO_CUCUMBER_JAVA = "io.cucumber.java";
    private static final String IO_CUCUMBER_JAVA_STEP_DEFINITION = "io.cucumber.java.*.*";

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType(IO_CUCUMBER_JAVA_STEP_DEFINITION);
    }

    public String getDisplayName() {
        return "Replace Cucumber-Java step definition regexes with Cucumber expressions";
    }

    public String getDescription() {
        return "Strip regex prefix and suffix from step annotation expressions arguments where possible.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CucumberStepDefinitionBodyVisitor();
    }

    static final class CucumberStepDefinitionBodyVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        CucumberStepDefinitionBodyVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration m, ExecutionContext p) {
            J.MethodDeclaration methodDeclaration = super.visitMethodDeclaration(m, (Object)p);
            return methodDeclaration.withLeadingAnnotations(ListUtils.map((List)methodDeclaration.getLeadingAnnotations(), ann -> CucumberStepDefinitionBodyVisitor.replaceRegexWithCucumberExpression(methodDeclaration, ann, p)));
        }

        private static J.Annotation replaceRegexWithCucumberExpression(J.MethodDeclaration methodDeclaration, J.Annotation annotation, ExecutionContext p) {
            JavaType.FullyQualified annoFqn = TypeUtils.asFullyQualified((JavaType)annotation.getType());
            if (annoFqn == null || !annoFqn.getPackageName().startsWith(RegexToCucumberExpression.IO_CUCUMBER_JAVA)) {
                return annotation;
            }
            List arguments = annotation.getArguments();
            Optional<String> possibleExpression = Stream.of(arguments).filter(Objects::nonNull).filter(list -> list.size() == 1).flatMap(Collection::stream).filter(J.Literal.class::isInstance).map(e -> (J.Literal)e).map(l -> (String)l.getValue()).filter(s -> s != null && (s.startsWith("^") || s.endsWith("$") || CucumberStepDefinitionBodyVisitor.leadingAndTrailingSlash(s))).findFirst();
            if (!possibleExpression.isPresent()) {
                return annotation;
            }
            String replacement = CucumberStepDefinitionBodyVisitor.stripAnchors(possibleExpression.get());
            if (Stream.of("(", ")", "{", "}", "[", "]", "?", "*", "+", "/", "\\", "^", "|").anyMatch(replacement::contains)) {
                return annotation;
            }
            String finalReplacement = String.format("\"%s\"", replacement);
            return annotation.withArguments(ListUtils.map((List)annotation.getArguments(), arg -> ((J.Literal)arg).withValue((Object)finalReplacement).withValueSource(finalReplacement)));
        }

        private static String stripAnchors(String initialExpression) {
            if (CucumberStepDefinitionBodyVisitor.leadingAndTrailingSlash(initialExpression)) {
                return initialExpression.substring(1, initialExpression.length() - 1);
            }
            String replacement = initialExpression;
            if (replacement.startsWith("^")) {
                replacement = replacement.substring(1);
            }
            if (replacement.endsWith("$")) {
                replacement = replacement.substring(0, replacement.length() - 1);
            }
            if (CucumberStepDefinitionBodyVisitor.leadingAndTrailingSlash(replacement)) {
                return initialExpression;
            }
            return replacement;
        }

        private static boolean leadingAndTrailingSlash(String initialExpression) {
            return initialExpression.startsWith("/") && initialExpression.endsWith("/");
        }
    }
}

