/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class CategoryToTag
extends Recipe {
    public String getDisplayName() {
        return "JUnit 4 `@Category` to JUnit Jupiter `@Tag`";
    }

    public String getDescription() {
        return "Transforms the JUnit 4 `@Category`, which can list multiple categories, into one `@Tag` annotation per category listed.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CategoryToTagVisitor();
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.experimental.categories.Category");
    }

    public static class CategoryToTagVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final JavaType.Class tagType = JavaType.ShallowClass.build((String)"org.junit.jupiter.api.Tag");

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            Set categoryAnnotations = FindAnnotations.find((J)cd, (String)"@org.junit.experimental.categories.Category");
            if (!categoryAnnotations.isEmpty()) {
                cd = cd.withLeadingAnnotations(cd.getLeadingAnnotations().stream().flatMap(this::categoryAnnotationToTagAnnotations).collect(Collectors.toList()));
                this.maybeRemoveImport("org.junit.experimental.categories.Category");
                this.maybeAddImport((JavaType.FullyQualified)tagType);
            }
            cd = (J.ClassDeclaration)this.maybeAutoFormat((J)classDecl, (J)cd, (J)cd.getName(), ctx, this.getCursor().getParentTreeCursor());
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            Set categoryAnnotations = FindAnnotations.find((J)m, (String)"@org.junit.experimental.categories.Category");
            if (!categoryAnnotations.isEmpty()) {
                m = m.withLeadingAnnotations(m.getLeadingAnnotations().stream().flatMap(this::categoryAnnotationToTagAnnotations).collect(Collectors.toList()));
                this.maybeRemoveImport("org.junit.experimental.categories.Category");
                this.maybeAddImport((JavaType.FullyQualified)tagType);
            }
            m = (J.MethodDeclaration)this.maybeAutoFormat((J)method, (J)m, (J)m.getName(), ctx, this.getCursor().getParentTreeCursor());
            return m;
        }

        private Stream<J.Annotation> categoryAnnotationToTagAnnotations(J.Annotation maybeCategory) {
            if (maybeCategory.getArguments() != null && TypeUtils.isOfClassType((JavaType)maybeCategory.getAnnotationType().getType(), (String)"org.junit.experimental.categories.Category")) {
                J.NewArray argArray;
                Expression annotationArgument = (Expression)maybeCategory.getArguments().iterator().next();
                if (annotationArgument instanceof J.Assignment) {
                    annotationArgument = ((J.Assignment)annotationArgument).getAssignment();
                }
                Stream<J.FieldAccess> categories = Stream.empty();
                if (annotationArgument instanceof J.NewArray && (argArray = (J.NewArray)annotationArgument).getInitializer() != null) {
                    categories = argArray.getInitializer().stream().map(J.FieldAccess.class::cast);
                }
                if (annotationArgument instanceof J.FieldAccess) {
                    categories = Stream.of((J.FieldAccess)annotationArgument);
                }
                return categories.map(category -> {
                    String targetName = ((J.Identifier)category.getTarget()).getSimpleName();
                    J.Annotation tagAnnotation = new J.Annotation(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (NameTree)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, tagType.getClassName(), (JavaType)tagType, null), JContainer.build((Space)Space.EMPTY, Collections.singletonList(new JRightPadded((Object)new J.Literal(Tree.randomId(), Space.EMPTY, Markers.EMPTY, (Object)targetName, "\"" + targetName + "\"", null, JavaType.Primitive.String), Space.EMPTY, Markers.EMPTY)), (Markers)Markers.EMPTY));
                    this.maybeRemoveImport(TypeUtils.asFullyQualified((JavaType)category.getTarget().getType()));
                    return tagAnnotation;
                });
            }
            return Stream.of(maybeCategory);
        }
    }
}

