/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Comparator;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public final class EnclosedToNested
extends Recipe {
    private static final String ENCLOSED = "org.junit.experimental.runners.Enclosed";
    private static final String RUN_WITH = "org.junit.runner.RunWith";
    private static final String NESTED = "org.junit.jupiter.api.Nested";
    private static final String TEST_JUNIT4 = "org.junit.Test";
    private static final String TEST_JUNIT_JUPITER = "org.junit.jupiter.api.Test";

    public String getDisplayName() {
        return "JUnit 4 `@RunWith(Enclosed.class)` to JUnit Jupiter `@Nested`";
    }

    public String getDescription() {
        return "Removes the `Enclosed` specification from a class, and adds `Nested` to its inner classes.";
    }

    public TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType(ENCLOSED);
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                Set runWithEnclosedAnnotationSet = FindAnnotations.find((J)cd.withBody(null), (String)String.format("@%s(%s.class)", EnclosedToNested.RUN_WITH, EnclosedToNested.ENCLOSED));
                for (J.Annotation runWithEnclosed : runWithEnclosedAnnotationSet) {
                    cd.getLeadingAnnotations().remove(runWithEnclosed);
                    cd = cd.withBody((J.Block)new AddNestedAnnotationVisitor().visit((Tree)cd.getBody(), ctx, this.getCursor()));
                    this.maybeRemoveImport(EnclosedToNested.ENCLOSED);
                    this.maybeRemoveImport(EnclosedToNested.RUN_WITH);
                    this.maybeAddImport(EnclosedToNested.NESTED);
                }
                return cd;
            }
        };
    }

    @NonNull
    public String toString() {
        return "EnclosedToNested()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnclosedToNested)) {
            return false;
        }
        EnclosedToNested other = (EnclosedToNested)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof EnclosedToNested;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class AddNestedAnnotationVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (this.hasTestMethods(cd)) {
                cd = (J.ClassDeclaration)cd.withTemplate((SourceTemplate)this.getNestedJavaTemplate(ctx), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                cd.getModifiers().removeIf(modifier -> modifier.getType().equals((Object)J.Modifier.Type.Static));
            }
            return cd;
        }

        @NonNull
        private JavaTemplate getNestedJavaTemplate(ExecutionContext ctx) {
            return JavaTemplate.builder(() -> ((AddNestedAnnotationVisitor)this).getCursor(), (String)"@Nested").javaParser(() -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2"}).build()).imports(new String[]{EnclosedToNested.NESTED}).build();
        }

        private boolean hasTestMethods(J.ClassDeclaration cd) {
            return !FindAnnotations.find((J)cd, (String)"@org.junit.Test").isEmpty() || !FindAnnotations.find((J)cd, (String)"@org.junit.jupiter.api.Test").isEmpty();
        }
    }
}

