/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;
import org.openrewrite.template.SourceTemplate;

public class JUnitParamsRunnerToParameterized
extends Recipe {
    private static final AnnotationMatcher RUN_WITH_JUNIT_PARAMS_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.runner.RunWith(junitparams.JUnitParamsRunner.class)");
    private static final AnnotationMatcher JUNIT_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.Test");
    private static final AnnotationMatcher JUPITER_TEST_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher PARAMETERS_MATCHER = new AnnotationMatcher("@junitparams.Parameters");
    private static final AnnotationMatcher TEST_CASE_NAME_MATCHER = new AnnotationMatcher("@junitparams.naming.TestCaseName");
    private static final AnnotationMatcher NAMED_PARAMETERS_MATCHER = new AnnotationMatcher("@junitparams.NamedParameters");
    private static final String INIT_METHOD_REFERENCES = "init-method-references";
    private static final String PARAMETERS_FOR_PREFIX = "parametersFor";
    private static final String INIT_METHODS_MAP = "named-parameters-map";
    private static final String CONVERSION_NOT_SUPPORTED = "conversion-not-supported";

    public String getDisplayName() {
        return "Pragmatists @RunWith(JUnitParamsRunner.class) to JUnit Jupiter Parameterized Tests";
    }

    public String getDescription() {
        return "Convert Pragmatists Parameterized test to the JUnit Jupiter ParameterizedTest equivalent.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    private static String junitParamsDefaultInitMethodName(String methodName) {
        return PARAMETERS_FOR_PREFIX + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("junitparams.*");
    }

    protected ParameterizedTemplateVisitor getVisitor() {
        return new ParameterizedTemplateVisitor();
    }

    private static class ParameterizedTemplateVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ParameterizedTemplateVisitor() {
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            Set initMethods = (Set)this.getCursor().getMessage(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES);
            if (initMethods != null && !initMethods.isEmpty()) {
                this.doAfterVisit((TreeVisitor)new ParametersNoArgsImplicitMethodSource(initMethods, (Map)this.getCursor().computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHODS_MAP, v -> new HashMap()), (Set)this.getCursor().computeMessageIfAbsent(JUnitParamsRunnerToParameterized.CONVERSION_NOT_SUPPORTED, v -> new HashSet()), ctx));
            }
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)executionContext);
            Cursor classDeclCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            if (m.getSimpleName().startsWith(JUnitParamsRunnerToParameterized.PARAMETERS_FOR_PREFIX)) {
                ((HashSet)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES, v -> new HashSet())).add(m.getSimpleName());
            }
            return m;
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext executionContext) {
            J.Annotation anno = super.visitAnnotation(annotation, (Object)executionContext);
            Cursor classDeclCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            if (PARAMETERS_MATCHER.matches(anno)) {
                String annotationArgumentValue = this.getAnnotationArgumentForInitMethod(anno, "method", "named");
                if (annotationArgumentValue != null) {
                    for (String method : annotationArgumentValue.split(",")) {
                        ((HashSet)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES, v -> new HashSet())).add(method);
                    }
                } else if (anno.getArguments() != null && !anno.getArguments().isEmpty()) {
                    String comment = " JunitParamsRunnerToParameterized conversion not supported";
                    if (anno.getComments().stream().noneMatch(c -> c.printComment(this.getCursor()).endsWith(comment))) {
                        anno = (J.Annotation)anno.withComments(ListUtils.concat((List)anno.getComments(), (Object)new TextComment(false, comment, "\n" + anno.getPrefix().getIndent(), Markers.EMPTY)));
                    }
                    J.MethodDeclaration m = (J.MethodDeclaration)this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).getValue();
                    Set unsupportedMethods = (Set)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.CONVERSION_NOT_SUPPORTED, v -> new HashSet());
                    unsupportedMethods.add(m.getSimpleName());
                    unsupportedMethods.add(JUnitParamsRunnerToParameterized.junitParamsDefaultInitMethodName(m.getSimpleName()));
                }
            } else if (NAMED_PARAMETERS_MATCHER.matches(annotation)) {
                String namedInitMethod = this.getLiteralAnnotationArgumentValue(annotation);
                if (namedInitMethod != null) {
                    J.MethodDeclaration m = (J.MethodDeclaration)this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).getValue();
                    ((HashSet)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHOD_REFERENCES, v -> new HashSet())).add(m.getSimpleName());
                    ((HashMap)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHODS_MAP, v -> new HashMap())).put(namedInitMethod, m.getSimpleName());
                }
            } else if (TEST_CASE_NAME_MATCHER.matches(anno)) {
                String testNameArg = this.getLiteralAnnotationArgumentValue(anno);
                String testName = testNameArg != null ? testNameArg.toString() : "{method}({params}) [{index}]";
                J.MethodDeclaration md = (J.MethodDeclaration)this.getCursor().dropParentUntil(J.MethodDeclaration.class::isInstance).getValue();
                ((HashMap)classDeclCursor.computeMessageIfAbsent(JUnitParamsRunnerToParameterized.INIT_METHODS_MAP, v -> new HashMap())).put(md.getSimpleName(), testName);
            }
            return anno;
        }

        @Nullable
        private String getLiteralAnnotationArgumentValue(J.Annotation anno) {
            String annotationArgumentValue = null;
            if (anno.getArguments() != null && anno.getArguments().size() == 1 && anno.getArguments().get(0) instanceof J.Literal) {
                J.Literal literal = (J.Literal)anno.getArguments().get(0);
                annotationArgumentValue = literal.getValue() != null ? literal.getValue().toString() : null;
            }
            return annotationArgumentValue;
        }

        @Nullable
        private String getAnnotationArgumentForInitMethod(J.Annotation anno, String ... variableNames) {
            String value = null;
            if (anno.getArguments() != null && anno.getArguments().size() == 1 && anno.getArguments().get(0) instanceof J.Assignment && ((J.Assignment)anno.getArguments().get(0)).getVariable() instanceof J.Identifier && ((J.Assignment)anno.getArguments().get(0)).getAssignment() instanceof J.Literal) {
                J.Assignment annoArg = (J.Assignment)anno.getArguments().get(0);
                J.Literal assignment = (J.Literal)annoArg.getAssignment();
                String identifier = ((J.Identifier)annoArg.getVariable()).getSimpleName();
                for (String variableName : variableNames) {
                    if (!variableName.equals(identifier)) continue;
                    value = assignment.getValue() != null ? assignment.getValue().toString() : null;
                    break;
                }
            }
            return value;
        }
    }

    private static class ParametersNoArgsImplicitMethodSource
    extends JavaIsoVisitor<ExecutionContext> {
        @Nullable
        private Supplier<JavaParser> javaParser;
        private final Set<String> initMethods;
        private final Set<String> unsupportedConversions;
        private final Map<String, String> initMethodReferences;
        private final JavaTemplate parameterizedTestTemplate;
        private final JavaTemplate parameterizedTestTemplateWithName;
        private final JavaTemplate methodSourceTemplate;

        private Supplier<JavaParser> javaParser(ExecutionContext ctx) {
            if (this.javaParser == null) {
                this.javaParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2", "hamcrest-2.2", "junit-jupiter-params-5.9.2"}).build();
            }
            return this.javaParser;
        }

        public ParametersNoArgsImplicitMethodSource(Set<String> initMethods, Map<String, String> initMethodReferences, Set<String> unsupportedConversions, ExecutionContext ctx) {
            this.initMethods = initMethods;
            this.initMethodReferences = initMethodReferences;
            this.unsupportedConversions = unsupportedConversions;
            this.parameterizedTestTemplate = JavaTemplate.builder(() -> ((ParametersNoArgsImplicitMethodSource)this).getCursor(), (String)"@ParameterizedTest").javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.params.ParameterizedTest"}).build();
            this.parameterizedTestTemplateWithName = JavaTemplate.builder(() -> ((ParametersNoArgsImplicitMethodSource)this).getCursor(), (String)"@ParameterizedTest(name = \"#{}\")").javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.params.ParameterizedTest"}).build();
            this.methodSourceTemplate = JavaTemplate.builder(() -> ((ParametersNoArgsImplicitMethodSource)this).getCursor(), (String)"@MethodSource(#{})").javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.params.provider.MethodSource"}).build();
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
            this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(RUN_WITH_JUNIT_PARAMS_ANNOTATION_MATCHER));
            this.maybeRemoveImport("org.junit.Test");
            this.maybeRemoveImport("org.junit.jupiter.api.Test");
            this.maybeRemoveImport("org.junit.runner.RunWith");
            this.maybeRemoveImport("junitparams.JUnitParamsRunner");
            this.maybeRemoveImport("junitparams.Parameters");
            this.maybeRemoveImport("junitparams.NamedParameters");
            this.maybeRemoveImport("junitparams.naming.TestCaseName");
            this.maybeAddImport("org.junit.jupiter.params.ParameterizedTest");
            this.maybeAddImport("org.junit.jupiter.params.provider.MethodSource");
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
            if (this.unsupportedConversions.contains(method.getSimpleName())) {
                return method;
            }
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)executionContext);
            String paramTestName = this.initMethodReferences.get(m.getSimpleName());
            if ((this.initMethods.contains((m = m.withLeadingAnnotations(ListUtils.map((List)m.getLeadingAnnotations(), anno -> {
                if (TEST_CASE_NAME_MATCHER.matches(anno) || NAMED_PARAMETERS_MATCHER.matches(anno)) {
                    return null;
                }
                anno = this.maybeReplaceTestAnnotation((J.Annotation)anno, paramTestName);
                anno = this.maybeReplaceParametersAnnotation((J.Annotation)anno, method.getSimpleName());
                return anno;
            }))).getSimpleName()) || this.initMethodReferences.containsValue(m.getSimpleName())) && m.getModifiers().stream().noneMatch(it -> J.Modifier.Type.Static.equals((Object)it.getType()))) {
                J.Modifier staticModifier = new J.Modifier(UUID.randomUUID(), Space.format((String)" "), Markers.EMPTY, J.Modifier.Type.Static, new ArrayList());
                m = (J.MethodDeclaration)this.maybeAutoFormat((J)m, (J)m.withModifiers(ListUtils.concat((List)m.getModifiers(), (Object)staticModifier)), executionContext, this.getCursor().getParentTreeCursor());
            }
            return m;
        }

        private J.Annotation maybeReplaceTestAnnotation(J.Annotation anno, @Nullable String parameterizedTestArgument) {
            if (JUPITER_TEST_ANNOTATION_MATCHER.matches(anno) || JUNIT_TEST_ANNOTATION_MATCHER.matches(anno)) {
                anno = parameterizedTestArgument == null ? (J.Annotation)anno.withTemplate((SourceTemplate)this.parameterizedTestTemplate, anno.getCoordinates().replace(), new Object[0]) : (J.Annotation)anno.withTemplate((SourceTemplate)this.parameterizedTestTemplateWithName, anno.getCoordinates().replace(), new Object[]{parameterizedTestArgument});
            }
            return anno;
        }

        private J.Annotation maybeReplaceParametersAnnotation(J.Annotation annotation, String methodName) {
            if (PARAMETERS_MATCHER.matches(annotation)) {
                String initMethodName = JUnitParamsRunnerToParameterized.junitParamsDefaultInitMethodName(methodName);
                if (this.initMethods.contains(initMethodName)) {
                    annotation = (J.Annotation)annotation.withTemplate((SourceTemplate)this.methodSourceTemplate, annotation.getCoordinates().replace(), new Object[]{"\"" + initMethodName + "\""});
                } else {
                    String annotationArg = this.getAnnotationArgumentValueForMethodTemplate(annotation);
                    if (annotationArg != null) {
                        annotation = (J.Annotation)annotation.withTemplate((SourceTemplate)this.methodSourceTemplate, annotation.getCoordinates().replace(), new Object[]{annotationArg});
                    }
                }
            }
            return annotation;
        }

        @Nullable
        private String getAnnotationArgumentValueForMethodTemplate(J.Annotation anno) {
            String annotationArgumentValue = null;
            if (anno.getArguments() != null && anno.getArguments().size() == 1) {
                Expression annoArg = (Expression)anno.getArguments().get(0);
                if (annoArg instanceof J.Literal) {
                    annotationArgumentValue = (String)((J.Literal)annoArg).getValue();
                } else if (annoArg instanceof J.Assignment && ((J.Assignment)annoArg).getAssignment() instanceof J.Literal) {
                    annotationArgumentValue = (String)((J.Literal)((J.Assignment)annoArg).getAssignment()).getValue();
                }
            }
            if (this.initMethodReferences.containsKey(annotationArgumentValue)) {
                annotationArgumentValue = this.initMethodReferences.get(annotationArgumentValue);
            }
            if (annotationArgumentValue != null) {
                String[] methodRefs = annotationArgumentValue.split(",");
                if (methodRefs.length > 1) {
                    String methods = Arrays.stream(methodRefs).map(mref -> "\"" + mref + "\"").collect(Collectors.joining(", "));
                    annotationArgumentValue = "{" + methods + "}";
                } else {
                    annotationArgumentValue = "\"" + annotationArgumentValue + "\"";
                }
            }
            return annotationArgumentValue;
        }
    }
}

