/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Collections;
import java.util.Comparator;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.junit5.RunnerToExtension;
import org.openrewrite.java.tree.J;
import org.openrewrite.template.SourceTemplate;

public class MockitoJUnitRunnerSilentToExtension
extends Recipe {
    public String getDisplayName() {
        return "JUnit 4 MockitoJUnitRunner.Silent to JUnit Jupiter MockitoExtension with LENIENT settings";
    }

    public String getDescription() {
        return "Replace `@RunWith(MockitoJUnitRunner.Silent.class)` with `@ExtendWith(MockitoExtension.class)` and `@MockitoSettings(strictness = Strictness.LENIENT)`.";
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.mockito.junit.MockitoJUnitRunner$Silent");
    }

    protected JavaIsoVisitor<ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            private Supplier<JavaParser> javaParser = null;
            final AnnotationMatcher silentRunnerMatcher = new AnnotationMatcher("org.junit.runner.RunWith @RunWith(org.mockito.junit.MockitoJUnitRunner.MockitoJUnitRunner.Silent.class)");

            private Supplier<JavaParser> javaParser(ExecutionContext ctx) {
                if (this.javaParser == null) {
                    this.javaParser = () -> JavaParser.fromJavaVersion().logCompilationWarningsAndErrors(true).classpathFromResources(ctx, new String[]{"mockito-junit-jupiter-3.12.4", "mockito-core-3.12.4"}).build();
                }
                return this.javaParser;
            }

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)this.silentRunnerMatcher).matches(arg_0))) {
                    JavaTemplate template = JavaTemplate.builder(() -> (this).getCursor(), (String)"@MockitoSettings(strictness = Strictness.LENIENT)").imports(new String[]{"org.mockito.quality.Strictness", "org.mockito.junit.jupiter.MockitoSettings"}).javaParser(this.javaParser(ctx)).build();
                    cd = (J.ClassDeclaration)this.maybeAutoFormat((J)cd, (J)((J.ClassDeclaration)cd.withTemplate((SourceTemplate)template, cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0])), ctx);
                    this.doAfterVisit(new RunnerToExtension(Collections.singletonList("org.mockito.junit.MockitoJUnitRunner$Silent"), "org.mockito.junit.jupiter.MockitoExtension"));
                    this.maybeRemoveImport("org.mockito.junit.MockitoJUnitRunner");
                    this.maybeAddImport("org.mockito.quality.Strictness");
                    this.maybeAddImport("org.mockito.junit.jupiter.MockitoSettings");
                }
                return cd;
            }
        };
    }
}

