/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public final class RemoveObsoleteRunners
extends Recipe {
    @Option(displayName="Obsolete Runners", description="The fully qualified class names of the JUnit 4 runners to be removed.", example="org.junit.runners.JUnit4")
    private final List<String> obsoleteRunners;

    public String getDisplayName() {
        return "Remove JUnit 4 `@RunWith` annotations that do not require an `@ExtendsWith` replacement";
    }

    public String getDescription() {
        return "Some JUnit 4 `@RunWith` annotations do not require replacement with an equivalent JUnit Jupiter `@ExtendsWith` annotation. This can be used to remove those runners that either do not have a JUnit Jupiter equivalent or do not require a replacement as part of JUnit 4 to 5 migration.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                for (String runner : RemoveObsoleteRunners.this.obsoleteRunners) {
                    this.doAfterVisit((TreeVisitor)new UsesType(runner, Boolean.valueOf(false)));
                }
                return cu;
            }
        };
    }

    protected RemoveObsoleteRunnersVisitor getVisitor() {
        return new RemoveObsoleteRunnersVisitor();
    }

    @ConstructorProperties(value={"obsoleteRunners"})
    public RemoveObsoleteRunners(List<String> obsoleteRunners) {
        this.obsoleteRunners = obsoleteRunners;
    }

    public List<String> getObsoleteRunners() {
        return this.obsoleteRunners;
    }

    @NonNull
    public String toString() {
        return "RemoveObsoleteRunners(obsoleteRunners=" + this.getObsoleteRunners() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveObsoleteRunners)) {
            return false;
        }
        RemoveObsoleteRunners other = (RemoveObsoleteRunners)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$obsoleteRunners = this.getObsoleteRunners();
        List<String> other$obsoleteRunners = other.getObsoleteRunners();
        return !(this$obsoleteRunners == null ? other$obsoleteRunners != null : !((Object)this$obsoleteRunners).equals(other$obsoleteRunners));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveObsoleteRunners;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $obsoleteRunners = this.getObsoleteRunners();
        result = result * 59 + ($obsoleteRunners == null ? 43 : ((Object)$obsoleteRunners).hashCode());
        return result;
    }

    public class RemoveObsoleteRunnersVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            for (String runner : RemoveObsoleteRunners.this.obsoleteRunners) {
                this.doAfterVisit((Recipe)new RemoveAnnotation("@org.junit.runner.RunWith(" + runner + ".class)"));
                this.maybeRemoveImport(runner);
            }
            this.maybeRemoveImport("org.junit.runner.RunWith");
            return classDecl;
        }
    }
}

