/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.ChangeType;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.template.SourceTemplate;

public class TestRuleToTestInfo
extends Recipe {
    public String getDisplayName() {
        return "JUnit TestName @Rule to JUnit Jupiter TestInfo";
    }

    public String getDescription() {
        return "Replace usages of JUnit 4's `@Rule TestName` with JUnit 5's TestInfo.";
    }

    protected UsesType<ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.junit.rules.TestName", Boolean.valueOf(false));
    }

    protected TestRuleToTestInfoVisitor getVisitor() {
        return new TestRuleToTestInfoVisitor();
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    private static class TestRuleToTestInfoVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final MethodMatcher TEST_NAME_GET_NAME = new MethodMatcher("org.junit.rules.TestName getMethodName()");
        private static final AnnotationMatcher RULE_ANNOTATION_MATCHER = new AnnotationMatcher("@org.junit.Rule");
        private static final AnnotationMatcher JUNIT_BEFORE_MATCHER = new AnnotationMatcher("@org.junit.Before");
        private static final AnnotationMatcher JUPITER_BEFORE_EACH_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.BeforeEach");
        @Nullable
        private Supplier<JavaParser> javaParser;

        private TestRuleToTestInfoVisitor() {
        }

        private Supplier<JavaParser> javaParser(ExecutionContext ctx) {
            if (this.javaParser == null) {
                this.javaParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2"}).build();
            }
            return this.javaParser;
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit compilationUnit = super.visitCompilationUnit(cu, (Object)ctx);
            this.maybeRemoveImport("org.junit.Rule");
            this.maybeRemoveImport("org.junit.rules.TestName");
            this.maybeAddImport("org.junit.jupiter.api.TestInfo");
            this.doAfterVisit((TreeVisitor)new JavaVisitor<ExecutionContext>(){

                public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                    J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                    if (TEST_NAME_GET_NAME.matches(mi) && mi.getSelect() != null) {
                        return mi.getSelect().withPrefix(Space.format((String)" "));
                    }
                    return mi;
                }
            });
            this.doAfterVisit((Recipe)new ChangeType("org.junit.rules.TestName", "java.lang.String", Boolean.valueOf(true)));
            this.doAfterVisit((Recipe)new ChangeType("org.junit.Before", "org.junit.jupiter.api.BeforeEach", Boolean.valueOf(true)));
            return compilationUnit;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations varDecls = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            if (varDecls.getType() != null && TypeUtils.isOfClassType((JavaType)varDecls.getType(), (String)"org.junit.rules.TestName")) {
                varDecls = varDecls.withLeadingAnnotations(ListUtils.map((List)varDecls.getLeadingAnnotations(), anno -> {
                    if (RULE_ANNOTATION_MATCHER.matches(anno)) {
                        return null;
                    }
                    return anno;
                }));
                this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("has-testName-rule", (Object)varDecls);
            }
            return varDecls;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext ctx) {
            J.NewClass nc = super.visitNewClass(newClass, (Object)ctx);
            if (TypeUtils.isOfClassType((JavaType)nc.getType(), (String)"org.junit.rules.TestName")) {
                return null;
            }
            return nc;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
            if (md.getLeadingAnnotations().stream().anyMatch(anno -> JUNIT_BEFORE_MATCHER.matches(anno) || JUPITER_BEFORE_EACH_MATCHER.matches(anno))) {
                this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("before-method", (Object)md);
            }
            return md;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            J.VariableDeclarations varDecls = (J.VariableDeclarations)this.getCursor().pollMessage("has-testName-rule");
            J.MethodDeclaration beforeMethod = (J.MethodDeclaration)this.getCursor().pollMessage("before-method");
            if (varDecls != null) {
                String testMethodStatement = "Optional<Method> testMethod = testInfo.getTestMethod();\nif (testMethod.isPresent()) {\n    this.#{} = testMethod.get().getName();\n}";
                if (beforeMethod == null) {
                    String t = "@BeforeEach\npublic void setup(TestInfo testInfo) {" + testMethodStatement + "}";
                    cd = (J.ClassDeclaration)cd.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((TestRuleToTestInfoVisitor)this).getCursor(), (String)t).javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.api.TestInfo", "org.junit.jupiter.api.BeforeEach", "java.util.Optional", "java.lang.reflect.Method"}).build(), cd.getBody().getCoordinates().lastStatement(), new Object[]{((J.VariableDeclarations.NamedVariable)varDecls.getVariables().get(0)).getName().getSimpleName()});
                    this.maybeAddImport("java.lang.reflect.Method");
                    this.maybeAddImport("java.util.Optional");
                } else {
                    this.doAfterVisit((TreeVisitor)new BeforeMethodToTestInfoVisitor(beforeMethod, varDecls, testMethodStatement));
                }
            }
            return cd;
        }
    }

    private static class BeforeMethodToTestInfoVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final J.MethodDeclaration beforeMethod;
        private final J.VariableDeclarations varDecls;
        private final String testMethodStatement;
        @Nullable
        private Supplier<JavaParser> javaParser;

        private Supplier<JavaParser> javaParser(ExecutionContext ctx) {
            if (this.javaParser == null) {
                this.javaParser = () -> JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9.2"}).build();
            }
            return this.javaParser;
        }

        public BeforeMethodToTestInfoVisitor(J.MethodDeclaration beforeMethod, J.VariableDeclarations varDecls, String testMethodStatement) {
            this.beforeMethod = beforeMethod;
            this.varDecls = varDecls;
            this.testMethodStatement = testMethodStatement;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
            if (md.getId().equals(this.beforeMethod.getId())) {
                md = (J.MethodDeclaration)md.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((BeforeMethodToTestInfoVisitor)this).getCursor(), (String)"TestInfo testInfo").javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.api.TestInfo", "org.junit.jupiter.api.BeforeEach", "java.util.Optional", "java.lang.reflect.Method"}).build(), md.getCoordinates().replaceParameters(), new Object[0]);
                md = (J.MethodDeclaration)this.maybeAutoFormat((J)md, (J)((J.MethodDeclaration)md.withTemplate((SourceTemplate)JavaTemplate.builder(() -> ((BeforeMethodToTestInfoVisitor)this).getCursor(), (String)this.testMethodStatement).javaParser(this.javaParser(ctx)).imports(new String[]{"org.junit.jupiter.api.TestInfo", "java.util.Optional", "java.lang.reflect.Method"}).build(), md.getBody().getCoordinates().lastStatement(), new Object[]{((J.VariableDeclarations.NamedVariable)this.varDecls.getVariables().get(0)).getName().getSimpleName()})), ctx, this.getCursor().getParent());
                assert (md.getBody() != null);
                if (md.getBody().getStatements().size() > 2) {
                    List statements = md.getBody().getStatements();
                    ArrayList reorderedStatements = new ArrayList(statements.size());
                    reorderedStatements.addAll(statements.subList(statements.size() - 2, statements.size()));
                    reorderedStatements.addAll(statements.subList(0, statements.size() - 2));
                    md = md.withBody(md.getBody().withStatements(reorderedStatements));
                }
                this.maybeAddImport("java.lang.reflect.Method");
                this.maybeAddImport("java.util.Optional");
            }
            return md;
        }
    }
}

