/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class CleanupMockitoImports
extends Recipe {
    public String getDisplayName() {
        return "Cleanup Mockito imports";
    }

    public String getDescription() {
        return "Removes unused `org.mockito` import symbols, unless its possible they are associated with method invocations having null or unknown type information.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new CleanupMockitoImportsVisitor();
    }

    @Nullable
    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new UsesType("org.mockito.*", Boolean.valueOf(false));
    }

    public static class CleanupMockitoImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final List<String> MOCKITO_METHOD_NAMES = Arrays.asList("after", "atLeast", "atLeastOnce", "atMost", "calls", "clearInvocations", "doAnswer", "doCallRealMethod", "doNothing", "doReturn", "doThrow", "given", "ignoreStubs", "inOrder", "mock", "mockingDetails", "never", "only", "reset", "spy", "stub", "stubVoid", "then", "timeout", "times", "verify", "verifyNoInteractions", "verifyNoMoreInteractions", "verifyZeroInteractions", "when", "will", "willAnswer", "willCallRealMethod", "willDoNothing", "willReturn", "willThrow");

        public JavaSourceFile visitJavaSourceFile(JavaSourceFile cu, ExecutionContext ctx) {
            JavaSourceFile sf = super.visitJavaSourceFile(cu, (Object)ctx);
            ArrayList<String> unknownTypeMethodInvocationNames = new ArrayList<String>();
            new WellFormedMockitoMethodTypeVisitor().visit((Tree)cu, unknownTypeMethodInvocationNames);
            for (J.Import _import : cu.getImports()) {
                if (!_import.getPackageName().startsWith("org.mockito")) continue;
                if (_import.isStatic()) {
                    String staticName = _import.getQualid().getSimpleName();
                    if ("*".equals(staticName) && !this.possibleMockitoMethod(unknownTypeMethodInvocationNames)) {
                        this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName());
                        continue;
                    }
                    if ("*".equals(staticName) || unknownTypeMethodInvocationNames.contains(staticName)) continue;
                    this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName() + "." + staticName);
                    continue;
                }
                this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName());
            }
            return sf;
        }

        private boolean possibleMockitoMethod(List<String> methodNamesHavingNullType) {
            for (String missingMethod : methodNamesHavingNullType) {
                if (!MOCKITO_METHOD_NAMES.contains(missingMethod)) continue;
                return true;
            }
            return false;
        }

        private static class WellFormedMockitoMethodTypeVisitor
        extends JavaIsoVisitor<List<String>> {
            private WellFormedMockitoMethodTypeVisitor() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> missingMethods) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, missingMethods);
                if (MOCKITO_METHOD_NAMES.contains(mi.getSimpleName()) && !TypeUtils.isWellFormedType((JavaType)mi.getType())) {
                    missingMethods.add(mi.getSimpleName());
                }
                return mi;
            }
        }
    }
}

