/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.Collection;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NonNullApi
public class AssertLiteralBooleanToFailRecipe
extends Recipe {
    public String getDisplayName() {
        return "Replace JUnit `assertTrue(false, \"reason\")` and `assertFalse(true, \"reason\")` with `fail(\"reason\")`";
    }

    public String getDescription() {
        return "Using fail is more direct and clear.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            final JavaTemplate assertFalseBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(true, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
            final JavaTemplate assertTrueBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(false, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
            final JavaTemplate after = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.fail(#{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

            public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher = this.assertFalseBefore.matcher(this.getCursor());
                if (matcher.find()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                matcher = this.assertTrueBefore.matcher(this.getCursor());
                if (matcher.find()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)", true), new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)", true)}), (TreeVisitor)javaVisitor);
    }
}

