/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotation;
import org.openrewrite.java.dependencies.DependencyInsight;
import org.openrewrite.java.search.FindAnnotations;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;

public class RetainStrictnessWarn
extends ScanningRecipe<AtomicBoolean> {
    private static final String EXTEND_WITH_FQ = "org.junit.jupiter.api.extension.ExtendWith";
    private static final String MOCKITO_EXTENSION_FQ = "org.mockito.junit.jupiter.MockitoExtension";
    private static final String MOCKITO_SETTINGS_FQ = "org.mockito.junit.jupiter.MockitoSettings";
    private static final String MOCKITO_STRICTNESS_FQ = "org.mockito.quality.Strictness";
    private static final String EXTEND_WITH_MOCKITO_EXTENSION = "@org.junit.jupiter.api.extension.ExtendWith(org.mockito.junit.jupiter.MockitoExtension.class)";

    public String getDisplayName() {
        return "Retain Mockito strictness `WARN` when switching to JUnit 5";
    }

    public String getDescription() {
        return "Migrating from JUnit 4 to 5 [changes the default strictness](https://stackoverflow.com/a/53234137/53444) of the mocks from `WARN` to `STRICT_STUBS`. To prevent tests from failing we restore the original behavior by adding `@MockitoSettings(strictness = Strictness.WARN)`.";
    }

    public AtomicBoolean getInitialValue(ExecutionContext ctx) {
        return new AtomicBoolean(false);
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final AtomicBoolean usingOlderMockito) {
        final TreeVisitor div = new DependencyInsight("org.mockito", "mockito-*", "[1.1,2.17)", null).getVisitor();
        return new TreeVisitor<Tree, ExecutionContext>(){

            public @Nullable Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (!usingOlderMockito.get() && div.visit(tree, (Object)ctx) != tree) {
                    usingOlderMockito.set(true);
                }
                return tree;
            }
        };
    }

    public TreeVisitor<?, ExecutionContext> getVisitor(AtomicBoolean usingOlderMockito) {
        return Preconditions.check((boolean)usingOlderMockito.get(), (TreeVisitor)Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType(MOCKITO_EXTENSION_FQ, Boolean.valueOf(true)), Preconditions.not((TreeVisitor)new UsesType(MOCKITO_SETTINGS_FQ, Boolean.valueOf(false)))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                Set annotations = FindAnnotations.find((J)classDecl, (String)RetainStrictnessWarn.EXTEND_WITH_MOCKITO_EXTENSION);
                if (!annotations.isEmpty()) {
                    this.maybeAddImport(RetainStrictnessWarn.MOCKITO_SETTINGS_FQ);
                    this.maybeAddImport(RetainStrictnessWarn.MOCKITO_STRICTNESS_FQ);
                    classDecl = (J.ClassDeclaration)JavaTemplate.builder((String)"@MockitoSettings(strictness = Strictness.WARN)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-junit-jupiter", "mockito-core"})).imports(new String[]{RetainStrictnessWarn.MOCKITO_SETTINGS_FQ, RetainStrictnessWarn.MOCKITO_STRICTNESS_FQ}).build().apply(this.getCursor(), classDecl.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                    this.doAfterVisit((TreeVisitor)new RemoveAnnotation(RetainStrictnessWarn.EXTEND_WITH_MOCKITO_EXTENSION).getVisitor());
                    this.maybeRemoveImport(RetainStrictnessWarn.EXTEND_WITH_FQ);
                    this.maybeRemoveImport(RetainStrictnessWarn.MOCKITO_EXTENSION_FQ);
                }
                return super.visitClassDeclaration(classDecl, (Object)ctx);
            }
        }));
    }
}

