/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.testing.jmockit.ArgumentMatchersRewriter;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

class ExpectationsBlockRewriter {
    private static final String WHEN_TEMPLATE_PREFIX = "when(#{any()}).";
    private static final String RETURN_TEMPLATE_PREFIX = "thenReturn(";
    private static final String THROW_TEMPLATE_PREFIX = "thenThrow(";
    private static final String PRIMITIVE_TEMPLATE_FIELD = "#{}";
    private static final String THROWABLE_TEMPLATE_FIELD = "#{any()}";
    private final JavaVisitor<ExecutionContext> visitor;
    private final ExecutionContext ctx;
    private final J.NewClass newExpectations;
    private final int bodyStatementIndex;
    private J.Block methodBody;
    private JavaCoordinates nextStatementCoordinates;
    private int numStatementsAdded = 0;

    private static String getObjectTemplateField(String fqn) {
        return "#{any(" + fqn + ")}";
    }

    ExpectationsBlockRewriter(JavaVisitor<ExecutionContext> visitor, ExecutionContext ctx, J.Block methodBody, J.NewClass newExpectations, int bodyStatementIndex) {
        this.visitor = visitor;
        this.ctx = ctx;
        this.methodBody = methodBody;
        this.newExpectations = newExpectations;
        this.bodyStatementIndex = bodyStatementIndex;
        this.nextStatementCoordinates = newExpectations.getCoordinates().replace();
    }

    J.Block rewriteMethodBody() {
        this.visitor.maybeRemoveImport("mockit.Expectations");
        assert (this.newExpectations.getBody() != null);
        J.Block expectationsBlock = (J.Block)this.newExpectations.getBody().getStatements().get(0);
        ArgumentMatchersRewriter amr = new ArgumentMatchersRewriter(this.visitor, this.ctx, expectationsBlock);
        expectationsBlock = amr.rewriteExpectationsBlock();
        ArrayList<Object> expectationStatements = new ArrayList<Statement>();
        for (Statement expectationStatement : expectationsBlock.getStatements()) {
            if (expectationStatement instanceof J.MethodInvocation) {
                J.MethodInvocation invocation = (J.MethodInvocation)expectationStatement;
                if (invocation.getSelect() == null && invocation.getName().getSimpleName().equals("returns")) {
                    expectationStatements.add(expectationStatement);
                    continue;
                }
                if (!expectationStatements.isEmpty()) {
                    this.rewriteMethodBody(expectationStatements);
                    expectationStatements = new ArrayList();
                }
            }
            expectationStatements.add(expectationStatement);
        }
        if (!expectationStatements.isEmpty()) {
            this.rewriteMethodBody(expectationStatements);
        }
        return this.methodBody;
    }

    private void rewriteMethodBody(List<Statement> expectationStatements) {
        J.MethodInvocation invocation = (J.MethodInvocation)expectationStatements.get(0);
        MockInvocationResults mockInvocationResults = ExpectationsBlockRewriter.buildMockInvocationResults(expectationStatements);
        if (!mockInvocationResults.getResults().isEmpty()) {
            this.rewriteExpectationResult(mockInvocationResults.getResults(), invocation);
        } else if (this.nextStatementCoordinates.isReplacement()) {
            this.removeExpectationsStatement();
        }
        if (mockInvocationResults.getTimes() != null) {
            this.writeMethodVerification(invocation, mockInvocationResults.getTimes());
        }
    }

    private void rewriteExpectationResult(List<Expression> results, J.MethodInvocation invocation) {
        this.visitor.maybeAddImport("org.mockito.Mockito", "when");
        String template = ExpectationsBlockRewriter.getMockitoStatementTemplate(results);
        ArrayList<Object> templateParams = new ArrayList<Object>();
        templateParams.add(invocation);
        templateParams.addAll(results);
        this.methodBody = (J.Block)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(this.ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.Mockito.*"}).build().apply(new Cursor(this.visitor.getCursor(), (Object)this.methodBody), this.nextStatementCoordinates, templateParams.toArray());
        if (!this.nextStatementCoordinates.isReplacement()) {
            ++this.numStatementsAdded;
        }
        this.nextStatementCoordinates = ((Statement)this.methodBody.getStatements().get(this.bodyStatementIndex + this.numStatementsAdded)).getCoordinates().after();
    }

    private void removeExpectationsStatement() {
        this.methodBody = (J.Block)JavaTemplate.builder((String)"").javaParser(JavaParser.fromJavaVersion()).build().apply(new Cursor(this.visitor.getCursor(), (Object)this.methodBody), this.nextStatementCoordinates, new Object[0]);
        this.nextStatementCoordinates = this.bodyStatementIndex == 0 ? this.methodBody.getCoordinates().firstStatement() : ((Statement)this.methodBody.getStatements().get(this.bodyStatementIndex + this.numStatementsAdded)).getCoordinates().after();
    }

    private void writeMethodVerification(J.MethodInvocation invocation, Expression times) {
        this.visitor.maybeAddImport("org.mockito.Mockito", "verify");
        this.visitor.maybeAddImport("org.mockito.Mockito", "times");
        String fqn = ExpectationsBlockRewriter.getInvocationSelectFullyQualifiedClassName(invocation);
        String verifyTemplate = ExpectationsBlockRewriter.getVerifyTemplate(invocation.getArguments(), fqn);
        Object[] templateParams = new Object[]{invocation.getSelect(), times, invocation.getName().getSimpleName()};
        this.methodBody = (J.Block)JavaTemplate.builder((String)verifyTemplate).javaParser(JavaParser.fromJavaVersion().classpathFromResources(this.ctx, new String[]{"mockito-core-3.12"})).staticImports(new String[]{"org.mockito.Mockito.*"}).imports(new String[]{fqn}).build().apply(new Cursor(this.visitor.getCursor(), (Object)this.methodBody), this.methodBody.getCoordinates().lastStatement(), templateParams);
    }

    private static String getMockitoStatementTemplate(List<Expression> results) {
        boolean buildingResults = false;
        StringBuilder templateBuilder = new StringBuilder(WHEN_TEMPLATE_PREFIX);
        for (Expression result : results) {
            JavaType resultType = result.getType();
            if (resultType instanceof JavaType.Primitive) {
                ExpectationsBlockRewriter.appendToTemplate(templateBuilder, buildingResults, RETURN_TEMPLATE_PREFIX, PRIMITIVE_TEMPLATE_FIELD);
            } else if (resultType instanceof JavaType.Class) {
                boolean isThrowable = TypeUtils.isAssignableTo((String)Throwable.class.getName(), (JavaType)resultType);
                if (isThrowable) {
                    ExpectationsBlockRewriter.appendToTemplate(templateBuilder, buildingResults, THROW_TEMPLATE_PREFIX, THROWABLE_TEMPLATE_FIELD);
                } else {
                    ExpectationsBlockRewriter.appendToTemplate(templateBuilder, buildingResults, RETURN_TEMPLATE_PREFIX, ExpectationsBlockRewriter.getObjectTemplateField(((JavaType.Class)resultType).getFullyQualifiedName()));
                }
            } else if (resultType instanceof JavaType.Parameterized) {
                ExpectationsBlockRewriter.appendToTemplate(templateBuilder, buildingResults, RETURN_TEMPLATE_PREFIX, ExpectationsBlockRewriter.getObjectTemplateField(((JavaType.Parameterized)resultType).getType().getFullyQualifiedName()));
            } else {
                throw new IllegalStateException("Unexpected expression type for template: " + result.getType());
            }
            buildingResults = true;
        }
        templateBuilder.append(");");
        return templateBuilder.toString();
    }

    private static void appendToTemplate(StringBuilder templateBuilder, boolean buildingResults, String templatePrefix, String templateField) {
        if (!buildingResults) {
            templateBuilder.append(templatePrefix);
        } else {
            templateBuilder.append(", ");
        }
        templateBuilder.append(templateField);
    }

    private static String getVerifyTemplate(List<Expression> arguments, String fqn) {
        if (arguments.isEmpty()) {
            return "verify(#{any(" + fqn + ")}, times(#{any(int)})).#{}();";
        }
        StringBuilder templateBuilder = new StringBuilder("verify(#{any(" + fqn + ")}, times(#{any(int)})).#{}(");
        for (Expression argument : arguments) {
            if (argument instanceof J.Literal) {
                templateBuilder.append(((J.Literal)argument).getValueSource());
            } else {
                templateBuilder.append(argument);
            }
            templateBuilder.append(", ");
        }
        templateBuilder.delete(templateBuilder.length() - 2, templateBuilder.length());
        templateBuilder.append(");");
        return templateBuilder.toString();
    }

    private static MockInvocationResults buildMockInvocationResults(List<Statement> expectationStatements) {
        int numResults = 0;
        boolean hasTimes = false;
        MockInvocationResults resultWrapper = new MockInvocationResults();
        for (int i = 1; i < expectationStatements.size(); ++i) {
            Statement expectationStatement = expectationStatements.get(i);
            if (expectationStatement instanceof J.MethodInvocation) {
                if (hasTimes) {
                    throw new IllegalStateException("times statement must be last in expectation");
                }
                J.MethodInvocation invocation = (J.MethodInvocation)expectationStatement;
                for (Expression argument : invocation.getArguments()) {
                    ++numResults;
                    resultWrapper.addResult(argument);
                }
                continue;
            }
            J.Assignment assignment = (J.Assignment)expectationStatement;
            if (!(assignment.getVariable() instanceof J.Identifier)) {
                throw new IllegalStateException("Unexpected assignment variable type: " + assignment.getVariable());
            }
            J.Identifier identifier = (J.Identifier)assignment.getVariable();
            boolean isResult = identifier.getSimpleName().equals("result");
            boolean isTimes = identifier.getSimpleName().equals("times");
            if (isResult) {
                if (hasTimes) {
                    throw new IllegalStateException("times statement must be last in expectation");
                }
                ++numResults;
                resultWrapper.addResult(assignment.getAssignment());
                continue;
            }
            if (!isTimes) continue;
            hasTimes = true;
            if (numResults > 1) {
                throw new IllegalStateException("multiple results cannot be used with times statement");
            }
            resultWrapper.setTimes(assignment.getAssignment());
        }
        return resultWrapper;
    }

    private static String getInvocationSelectFullyQualifiedClassName(J.MethodInvocation invocation) {
        Expression select = invocation.getSelect();
        if (select == null || select.getType() == null) {
            throw new IllegalStateException("Missing type information for invocation select field: " + select);
        }
        String fqn = "";
        if (select instanceof J.Identifier) {
            fqn = ((JavaType.FullyQualified)Objects.requireNonNull(select.getType())).getFullyQualifiedName();
        }
        return fqn;
    }

    private static class MockInvocationResults {
        private final List<Expression> results = new ArrayList<Expression>();
        private Expression times;

        private MockInvocationResults() {
        }

        private List<Expression> getResults() {
            return this.results;
        }

        private void addResult(Expression result) {
            this.results.add(result);
        }

        private Expression getTimes() {
            return this.times;
        }

        private void setTimes(Expression times) {
            this.times = times;
        }
    }
}

