/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.testing.jmockit.JMockitUtils;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

class SetupStatementsRewriter {
    private final JavaVisitor<ExecutionContext> visitor;
    private J.Block methodBody;

    SetupStatementsRewriter(JavaVisitor<ExecutionContext> visitor, J.Block methodBody) {
        this.visitor = visitor;
        this.methodBody = methodBody;
    }

    J.Block rewriteMethodBody() {
        List statements = this.methodBody.getStatements();
        for (Statement s : statements) {
            if (!JMockitUtils.isExpectationsNewClassStatement(s)) continue;
            J.NewClass nc = (J.NewClass)s;
            assert (nc.getBody() != null);
            JavaCoordinates coordinates = nc.getCoordinates().before();
            J.Block expectationsBlock = (J.Block)nc.getBody().getStatements().get(0);
            ArrayList<Statement> newExpectationsBlockStatements = new ArrayList<Statement>();
            for (Statement expectationStatement : expectationsBlock.getStatements()) {
                if (!SetupStatementsRewriter.isSetupStatement(expectationStatement)) {
                    newExpectationsBlockStatements.add(expectationStatement);
                    continue;
                }
                this.rewriteBodyStatement(expectationStatement, coordinates);
                coordinates = expectationStatement.getCoordinates().after();
            }
            J.Block newExpectationsBlock = expectationsBlock.withStatements(newExpectationsBlockStatements);
            nc = nc.withBody(nc.getBody().withStatements(Collections.singletonList(newExpectationsBlock)));
            this.rewriteBodyStatement((Statement)nc, nc.getCoordinates().replace());
        }
        return this.methodBody;
    }

    private void rewriteBodyStatement(Statement statement, JavaCoordinates coordinates) {
        this.methodBody = (J.Block)JavaTemplate.builder((String)"#{any()}").javaParser(JavaParser.fromJavaVersion()).build().apply(new Cursor(this.visitor.getCursor(), (Object)this.methodBody), coordinates, new Object[]{statement});
    }

    private static boolean isSetupStatement(Statement expectationStatement) {
        if (expectationStatement instanceof J.MethodInvocation) {
            J.MethodInvocation methodInvocation = (J.MethodInvocation)expectationStatement;
            if (methodInvocation.getSelect() instanceof J.MethodInvocation) {
                return SetupStatementsRewriter.isSetupStatement((Statement)methodInvocation.getSelect());
            }
            if (methodInvocation.getSelect() instanceof J.Identifier) {
                return SetupStatementsRewriter.isNotMockIdentifier((J.Identifier)methodInvocation.getSelect());
            }
            if (methodInvocation.getSelect() instanceof J.FieldAccess) {
                return SetupStatementsRewriter.isNotMockIdentifier((J.Identifier)((J.FieldAccess)methodInvocation.getSelect()).getTarget());
            }
            return SetupStatementsRewriter.isNotMockIdentifier(methodInvocation.getName());
        }
        if (expectationStatement instanceof J.Assignment) {
            J.Assignment assignment = (J.Assignment)expectationStatement;
            J.Identifier identifier = (J.Identifier)assignment.getVariable();
            return !identifier.getSimpleName().equals("result") && !identifier.getSimpleName().equals("times");
        }
        return true;
    }

    private static boolean isNotMockIdentifier(J.Identifier identifier) {
        if (identifier.getType() instanceof JavaType.Method && TypeUtils.isAssignableTo((String)"mockit.Expectations", (JavaType)((JavaType.Method)identifier.getType()).getDeclaringType())) {
            return false;
        }
        JavaType.Variable fieldType = identifier.getFieldType();
        if (fieldType == null) {
            return true;
        }
        for (JavaType.FullyQualified annotationType : fieldType.getAnnotations()) {
            if (!TypeUtils.isAssignableTo((String)"mockit.Mocked", (JavaType)annotationType) && !TypeUtils.isAssignableTo((String)"org.mockito.Mock", (JavaType)annotationType) && !TypeUtils.isAssignableTo((String)"mockit.Injectable", (JavaType)annotationType) && !TypeUtils.isAssignableTo((String)"mockit.Tested", (JavaType)annotationType) && !TypeUtils.isAssignableTo((String)"org.mockito.InjectMocks", (JavaType)annotationType)) continue;
            return false;
        }
        return true;
    }
}

