/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.jmockit;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.testing.jmockit.ExpectationsBlockRewriter;
import org.openrewrite.java.testing.jmockit.JMockitUtils;
import org.openrewrite.java.testing.jmockit.SetupStatementsRewriter;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

public final class JMockitExpectationsToMockito
extends Recipe {
    public String getDisplayName() {
        return "Rewrite JMockit Expectations";
    }

    public String getDescription() {
        return "Rewrites JMockit `Expectations` blocks to Mockito statements.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("mockit.Expectations", Boolean.valueOf(false)), (TreeVisitor)new RewriteExpectationsVisitor());
    }

    @NonNull
    public String toString() {
        return "JMockitExpectationsToMockito()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JMockitExpectationsToMockito)) {
            return false;
        }
        JMockitExpectationsToMockito other = (JMockitExpectationsToMockito)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof JMockitExpectationsToMockito;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class RewriteExpectationsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private RewriteExpectationsVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
            if (md.getBody() == null) {
                return md;
            }
            SetupStatementsRewriter ssr = new SetupStatementsRewriter((JavaVisitor<ExecutionContext>)this, md.getBody());
            J.Block methodBody = ssr.rewriteMethodBody();
            List statements = methodBody.getStatements();
            int bodyStatementIndex = 0;
            while (bodyStatementIndex < statements.size()) {
                if (!JMockitUtils.isValidExpectationsNewClassStatement((Statement)statements.get(bodyStatementIndex))) {
                    ++bodyStatementIndex;
                    continue;
                }
                ExpectationsBlockRewriter ebr = new ExpectationsBlockRewriter((JavaVisitor<ExecutionContext>)this, ctx, methodBody, (J.NewClass)statements.get(bodyStatementIndex), bodyStatementIndex);
                methodBody = ebr.rewriteMethodBody();
                bodyStatementIndex = 0;
                statements = methodBody.getStatements();
            }
            return md.withBody(methodBody);
        }
    }
}

