/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveUnusedImports;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public class JUnitFailToAssertJFail
extends Recipe {
    public String getDisplayName() {
        return "JUnit fail to AssertJ";
    }

    public String getDescription() {
        return "Convert JUnit-style `fail()` to AssertJ's `fail()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.jupiter.api.Assertions", Boolean.valueOf(false)), (TreeVisitor)new JUnitFailToAssertJFailVisitor());
    }

    public static class JUnitFailToAssertJFailVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private JavaParser.Builder<?, ?> assertionsParser;
        private static final MethodMatcher JUNIT_FAIL_MATCHER = new MethodMatcher("org.junit.jupiter.api.Assertions fail(..)");

        private JavaParser.Builder<?, ?> assertionsParser(ExecutionContext ctx) {
            if (this.assertionsParser == null) {
                this.assertionsParser = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"});
            }
            return this.assertionsParser;
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = method;
            if (!JUNIT_FAIL_MATCHER.matches((MethodCall)m)) {
                return m;
            }
            List args = m.getArguments();
            if (args.size() == 1) {
                m = args.get(0) instanceof J.Empty ? (J.MethodInvocation)JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(\"\");").javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[0]) : (args.get(0) instanceof J.Literal || TypeUtils.isAssignableTo((String)"java.lang.String", (JavaType)((Expression)args.get(0)).getType()) ? (J.MethodInvocation)JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(#{any()});").javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{args.get(0)}) : (J.MethodInvocation)JavaTemplate.builder((String)"org.assertj.core.api.Assertions.fail(\"\", #{any()});").javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{args.get(0)}));
            } else {
                StringBuilder templateBuilder = new StringBuilder("org.assertj.core.api.Assertions.fail(");
                for (int i = 0; i < args.size(); ++i) {
                    templateBuilder.append("#{any()}");
                    if (i >= args.size() - 1) continue;
                    templateBuilder.append(", ");
                }
                templateBuilder.append(");");
                m = (J.MethodInvocation)JavaTemplate.builder((String)templateBuilder.toString()).javaParser(this.assertionsParser(ctx)).build().apply(this.getCursor(), m.getCoordinates().replace(), args.toArray());
            }
            this.doAfterVisit(new RemoveUnusedImports().getVisitor());
            this.doAfterVisit((TreeVisitor)new UnqualifiedMethodInvocations());
            return m;
        }

        private static class UnqualifiedMethodInvocations
        extends JavaIsoVisitor<ExecutionContext> {
            private static final MethodMatcher ASSERTJ_FAIL_MATCHER = new MethodMatcher("org.assertj.core.api.Assertions fail(..)");

            private UnqualifiedMethodInvocations() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (!ASSERTJ_FAIL_MATCHER.matches((MethodCall)method)) {
                    return method;
                }
                StringBuilder templateBuilder = new StringBuilder("fail(");
                List arguments = method.getArguments();
                for (int i = 0; i < arguments.size(); ++i) {
                    templateBuilder.append("#{any()}");
                    if (i >= arguments.size() - 1) continue;
                    templateBuilder.append(", ");
                }
                templateBuilder.append(");");
                method = (J.MethodInvocation)JavaTemplate.builder((String)templateBuilder.toString()).staticImports(new String[]{"org.assertj.core.api.Assertions.fail"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).build().apply(this.getCursor(), method.getCoordinates().replace(), arguments.toArray());
                this.maybeAddImport("org.assertj.core.api.Assertions", "fail", false);
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        }
    }
}

