/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.dbrider;

import java.util.Comparator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;

public class ExecutionListenerToDbRiderAnnotation
extends Recipe {
    private static final AnnotationMatcher EXECUTION_LISTENER_ANNOTATION_MATCHER = new AnnotationMatcher("@org.springframework.test.context.TestExecutionListeners");
    private static final AnnotationMatcher DBRIDER_ANNOTATION_MATCHER = new AnnotationMatcher("@com.github.database.rider.junit5.api.DBRider");
    private static final String DBRIDER_TEST_EXECUTION_LISTENER = "com.github.database.rider.spring.DBRiderTestExecutionListener";

    public String getDisplayName() {
        return "Migrate the `DBRiderTestExecutionListener` to the `@DBRider` annotation";
    }

    public String getDescription() {
        return "Migrate the `DBRiderTestExecutionListener` to the `@DBRider` annotation. This recipe is useful when migrating from JUnit 4 `dbrider-spring` to JUnit 5 `dbrider-junit5`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType(DBRIDER_TEST_EXECUTION_LISTENER, Boolean.valueOf(true)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDeclaration, (Object)ctx);
                DbRiderExecutionListenerContext context = DbRiderExecutionListenerContext.ofClass(cd);
                if (!context.shouldMigrate()) {
                    return cd;
                }
                if (context.shouldAddDbRiderAnnotation()) {
                    cd = (J.ClassDeclaration)JavaTemplate.builder((String)"@DBRider").imports(new String[]{"com.github.database.rider.junit5.api.DBRider"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"rider-junit5-1.44"})).build().apply(this.getCursor(), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                    this.maybeAddImport("com.github.database.rider.junit5.api.DBRider");
                }
                Space prefix = ((J.Annotation)cd.getLeadingAnnotations().get(cd.getLeadingAnnotations().size() - 1)).getPrefix();
                return cd.withLeadingAnnotations(ListUtils.map((List)cd.getLeadingAnnotations(), annotation -> {
                    if (annotation != null && EXECUTION_LISTENER_ANNOTATION_MATCHER.matches(annotation)) {
                        J.Annotation executionListenerAnnotation = context.getExecutionListenerAnnotation();
                        this.maybeRemoveImport(ExecutionListenerToDbRiderAnnotation.DBRIDER_TEST_EXECUTION_LISTENER);
                        this.maybeRemoveImport("org.springframework.test.context.TestExecutionListeners.MergeMode");
                        this.maybeRemoveImport("org.springframework.test.context.TestExecutionListeners");
                        if (executionListenerAnnotation != null) {
                            return executionListenerAnnotation.withArguments(ExecutionListenerToDbRiderAnnotation.firstItemPrefixWorkaround(executionListenerAnnotation.getArguments())).withPrefix(prefix);
                        }
                        return null;
                    }
                    return annotation;
                }));
            }
        });
    }

    private static <T extends Expression> @Nullable List<T> firstItemPrefixWorkaround(@Nullable List<T> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        return ListUtils.mapFirst(list, t -> (Expression)t.withPrefix(t.getPrefix().withWhitespace(t.getPrefix().getLastWhitespace().replaceAll(" $", ""))));
    }

    private static class DbRiderExecutionListenerContext {
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.Annotation testExecutionListenerAnnotation;
        private boolean dbriderFound = false;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.NewArray listeners;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.FieldAccess listener;
        private @Nullable Expression inheritListeners;
        private @Nullable Expression mergeMode;

        private DbRiderExecutionListenerContext() {
        }

        static DbRiderExecutionListenerContext ofClass(J.ClassDeclaration clazz) {
            DbRiderExecutionListenerContext context = new DbRiderExecutionListenerContext();
            clazz.getLeadingAnnotations().forEach(annotation -> {
                if (EXECUTION_LISTENER_ANNOTATION_MATCHER.matches(annotation)) {
                    context.testExecutionListenersFound((J.Annotation)annotation);
                } else if (DBRIDER_ANNOTATION_MATCHER.matches(annotation)) {
                    context.dbriderFound = true;
                }
            });
            return context;
        }

        private void testExecutionListenersFound(J.Annotation annotation) {
            this.testExecutionListenerAnnotation = annotation;
            if (annotation.getArguments() != null) {
                annotation.getArguments().forEach(arg -> {
                    if (arg instanceof J.Assignment) {
                        J.Assignment assignment = (J.Assignment)arg;
                        switch (((J.Identifier)assignment.getVariable()).getSimpleName()) {
                            case "value": 
                            case "listeners": {
                                if (!(assignment.getAssignment() instanceof J.NewArray)) break;
                                this.listeners = (J.NewArray)assignment.getAssignment();
                                break;
                            }
                            case "inheritListeners": {
                                this.inheritListeners = assignment.getAssignment();
                                break;
                            }
                            case "mergeMode": {
                                this.mergeMode = assignment.getAssignment();
                            }
                        }
                    } else if (arg instanceof J.NewArray) {
                        this.listeners = (J.NewArray)arg;
                    } else if (arg instanceof J.FieldAccess) {
                        this.listener = (J.FieldAccess)arg;
                    }
                });
            }
        }

        public boolean shouldMigrate() {
            return this.isTestExecutionListenerForDbRider() && !this.dbriderFound;
        }

        public boolean shouldAddDbRiderAnnotation() {
            if (this.dbriderFound) {
                return false;
            }
            return this.isTestExecutionListenerForDbRider();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.Annotation getExecutionListenerAnnotation() {
            if (this.isTestExecutionListenerForDbRider()) {
                if (this.canTestExecutionListenerBeRemoved()) {
                    return null;
                }
                if (this.testExecutionListenerAnnotation != null && this.testExecutionListenerAnnotation.getArguments() != null) {
                    return this.testExecutionListenerAnnotation.withArguments(ListUtils.map((List)this.testExecutionListenerAnnotation.getArguments(), arg -> {
                        if (arg instanceof J.Assignment) {
                            J.Assignment assignment = (J.Assignment)arg;
                            Expression newValue = assignment.getAssignment();
                            switch (((J.Identifier)assignment.getVariable()).getSimpleName()) {
                                case "value": 
                                case "listeners": {
                                    if (!(assignment.getAssignment() instanceof J.NewArray)) break;
                                    newValue = this.getMigratedListeners();
                                    break;
                                }
                                case "inheritListeners": {
                                    newValue = this.getMigratedInheritListeners();
                                    break;
                                }
                                case "mergeMode": {
                                    newValue = this.getMigratedMergeMode();
                                }
                            }
                            if (newValue == null) {
                                return null;
                            }
                            return assignment.withAssignment(newValue);
                        }
                        if (arg instanceof J.NewArray) {
                            return this.getMigratedListeners();
                        }
                        if (arg instanceof J.FieldAccess && DbRiderExecutionListenerContext.isTypeReference(arg, ExecutionListenerToDbRiderAnnotation.DBRIDER_TEST_EXECUTION_LISTENER)) {
                            return null;
                        }
                        return arg;
                    }));
                }
            }
            return this.testExecutionListenerAnnotation;
        }

        private boolean canTestExecutionListenerBeRemoved() {
            if (this.listener == null && this.listeners != null && this.listeners.getInitializer() != null && this.listeners.getInitializer().stream().allMatch(listener -> DbRiderExecutionListenerContext.isTypeReference(listener, ExecutionListenerToDbRiderAnnotation.DBRIDER_TEST_EXECUTION_LISTENER))) {
                return this.getMigratedInheritListeners() == null && this.getMigratedMergeMode() != null;
            }
            return false;
        }

        private @Nullable Expression getMigratedMergeMode() {
            if (this.mergeMode != null && this.mergeMode instanceof J.FieldAccess && "REPLACE_DEFAULTS".equals(((J.FieldAccess)this.mergeMode).getName().getSimpleName())) {
                return null;
            }
            return this.mergeMode;
        }

        private @Nullable Expression getMigratedInheritListeners() {
            if (this.inheritListeners != null && this.inheritListeners instanceof J.Literal && Boolean.TRUE.equals(((J.Literal)this.inheritListeners).getValue())) {
                return null;
            }
            return this.inheritListeners;
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.NewArray getMigratedListeners() {
            if (this.listeners != null && this.listeners.getInitializer() != null) {
                List newListeners = ListUtils.map((List)this.listeners.getInitializer(), listener -> {
                    if (listener instanceof J.FieldAccess && DbRiderExecutionListenerContext.isTypeReference(listener, ExecutionListenerToDbRiderAnnotation.DBRIDER_TEST_EXECUTION_LISTENER)) {
                        return null;
                    }
                    return listener;
                });
                if (newListeners.isEmpty()) {
                    return null;
                }
                return this.listeners.withInitializer(ExecutionListenerToDbRiderAnnotation.firstItemPrefixWorkaround(newListeners));
            }
            return this.listeners;
        }

        private boolean isTestExecutionListenerForDbRider() {
            if (this.listener != null) {
                return DbRiderExecutionListenerContext.isTypeReference((Expression)this.listener, ExecutionListenerToDbRiderAnnotation.DBRIDER_TEST_EXECUTION_LISTENER);
            }
            if (this.listeners != null && this.listeners.getInitializer() != null) {
                return this.listeners.getInitializer().stream().anyMatch(listener -> DbRiderExecutionListenerContext.isTypeReference(listener, ExecutionListenerToDbRiderAnnotation.DBRIDER_TEST_EXECUTION_LISTENER));
            }
            return false;
        }

        private static boolean isTypeReference(Expression expression, String type) {
            return expression.getType() instanceof JavaType.Parameterized && ((JavaType.Parameterized)expression.getType()).getFullyQualifiedName().equals("java.lang.Class") && ((JavaType.Parameterized)expression.getType()).getTypeParameters().size() == 1 && ((JavaType.Parameterized)expression.getType()).getTypeParameters().get(0) instanceof JavaType.Class && ((JavaType.Class)((JavaType.Parameterized)expression.getType()).getTypeParameters().get(0)).getFullyQualifiedName().equals(type);
        }
    }
}

