/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.VariableNameUtils;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.trait.Traits;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class CloseUnclosedStaticMocks
extends Recipe {
    private static final String LIFECYCLE_METHOD = "lifecycle_method";
    private static final MethodMatcher MOCK_STATIC_MATCHER = new MethodMatcher("org.mockito.Mockito mockStatic(..)");
    private static final AnnotationMatcher BEFORE_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.Before*");
    private static final AnnotationMatcher AFTER_EACH_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.AfterEach");
    private static final AnnotationMatcher AFTER_ALL_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.AfterAll");

    public String getDisplayName() {
        return "Close unclosed static mocks";
    }

    public String getDescription() {
        return "Ensures that all `mockStatic` calls are properly closed. If `mockStatic` is in lifecycle methods like `@BeforeEach` or `@BeforeAll`, creates a class variable and closes it in `@AfterEach` or `@AfterAll`. If `mockStatic` is inside a test method, wraps it in a try-with-resources block.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(MOCK_STATIC_MATCHER), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                J j = super.visitCompilationUnit(cu, (Object)ctx);
                this.maybeAddImport("org.mockito.MockedStatic");
                this.maybeAddImport("org.junit.jupiter.api.AfterEach");
                this.maybeAddImport("org.junit.jupiter.api.AfterAll");
                return j;
            }

            public J visitTryResource(J.Try.Resource tryResource, ExecutionContext ctx) {
                return tryResource;
            }

            public J visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                Cursor cursor = this.getCursor();
                Traits.annotated((AnnotationMatcher)BEFORE_MATCHER).asVisitor(a -> {
                    cursor.putMessage(CloseUnclosedStaticMocks.LIFECYCLE_METHOD, (Object)((J.Annotation)a.getTree()).getSimpleName());
                    return a.getTree();
                }).visit((Tree)method, (Object)ctx);
                return super.visitMethodDeclaration(method, (Object)ctx);
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                String mockedClassName;
                J.MethodInvocation mi = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                String lifeCycleMethod = (String)this.getCursor().getNearestMessage(CloseUnclosedStaticMocks.LIFECYCLE_METHOD);
                if (!MOCK_STATIC_MATCHER.matches((MethodCall)mi) || lifeCycleMethod == null) {
                    return mi;
                }
                if (this.getCursor().getParentTreeCursor().getValue() instanceof J.Block && (mockedClassName = this.getMockedClassName(mi)) != null) {
                    Cursor classCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
                    String varName = VariableNameUtils.generateVariableName((String)("mockedStatic" + mockedClassName), (Cursor)classCursor, (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                    J.Assignment assignment = (J.Assignment)JavaTemplate.builder((String)(varName + " = #{any()}")).build().apply(this.updateCursor((Tree)mi), mi.getCoordinates().replace(), new Object[]{mi});
                    this.doAfterVisit((TreeVisitor)new DeclareMockVarAndClose(varName, mockedClassName, lifeCycleMethod.equals("BeforeAll")));
                    return assignment;
                }
                return mi;
            }

            public J visitAssignment(J.Assignment assignment, ExecutionContext ctx) {
                JavaType.Variable varType;
                if (MOCK_STATIC_MATCHER.matches(assignment.getAssignment()) && assignment.getVariable() instanceof J.Identifier && (varType = ((J.Identifier)assignment.getVariable()).getFieldType()) != null && varType.getOwner() instanceof JavaType.Class) {
                    this.doAfterVisit((TreeVisitor)new DeclareMockVarAndClose(varType.getName(), null, varType.getFlags().contains(Flag.Static)));
                }
                return super.visitAssignment(assignment, (Object)ctx);
            }

            public J visitVariableDeclarations(J.VariableDeclarations variableDeclarations, ExecutionContext ctx) {
                J.VariableDeclarations vd = (J.VariableDeclarations)super.visitVariableDeclarations(variableDeclarations, (Object)ctx);
                J.VariableDeclarations.NamedVariable namedVariable = (J.VariableDeclarations.NamedVariable)vd.getVariables().get(0);
                String lifeCycleMethod = (String)this.getCursor().getNearestMessage(CloseUnclosedStaticMocks.LIFECYCLE_METHOD);
                if (!MOCK_STATIC_MATCHER.matches(namedVariable.getInitializer()) || lifeCycleMethod == null) {
                    return vd;
                }
                String varName = namedVariable.getSimpleName();
                String mockedClassName = this.getMockedClassName((J.MethodInvocation)namedVariable.getInitializer());
                if (mockedClassName != null) {
                    this.doAfterVisit((TreeVisitor)new DeclareMockVarAndClose(varName, mockedClassName, lifeCycleMethod.equals("BeforeAll")));
                    return JavaTemplate.builder((String)(varName + " = #{any()}")).contextSensitive().build().apply(this.updateCursor((Tree)vd), vd.getCoordinates().replace(), new Object[]{namedVariable.getInitializer()});
                }
                return vd;
            }

            public J visitBlock(J.Block block, ExecutionContext ctx) {
                J.Block b = (J.Block)super.visitBlock(block, (Object)ctx);
                if (this.getCursor().getNearestMessage(CloseUnclosedStaticMocks.LIFECYCLE_METHOD) != null) {
                    return b;
                }
                AtomicBoolean removeStatement = new AtomicBoolean(false);
                J.Block b1 = block.withStatements(ListUtils.map((List)b.getStatements(), statement -> {
                    J.Try tryWithResource;
                    if (!removeStatement.get() && this.shouldUseTryWithResources((Statement)statement) && (tryWithResource = this.toTryWithResource(b, (Statement)statement, ctx)) != null) {
                        removeStatement.set(true);
                        return (J.Try)super.visitTry(tryWithResource, (Object)ctx);
                    }
                    return removeStatement.get() ? null : statement;
                }));
                return this.maybeAutoFormat((J)b, (J)b1, ctx);
            }

            private // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.Try toTryWithResource(J.Block block, Statement statement, ExecutionContext ctx) {
                String code = null;
                if (statement instanceof J.MethodInvocation) {
                    String mockedClassName = this.getMockedClassName((J.MethodInvocation)statement);
                    if (mockedClassName != null) {
                        String varName = VariableNameUtils.generateVariableName((String)("mockedStatic" + mockedClassName), (Cursor)this.getCursor(), (VariableNameUtils.GenerationStrategy)VariableNameUtils.GenerationStrategy.INCREMENT_NUMBER);
                        code = String.format("try(MockedStatic<%s> %s = #{any()}) {}", mockedClassName, varName);
                    }
                } else if (statement instanceof J.VariableDeclarations || statement instanceof J.Assignment) {
                    code = "try(#{any()}) {}";
                }
                if (code == null) {
                    return null;
                }
                J.Try tryWithResources = (J.Try)JavaTemplate.builder((String)code).contextSensitive().imports(new String[]{"org.mockito.MockedStatic"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).build().apply(new Cursor(this.getCursor(), (Object)statement), statement.getCoordinates().replace(), new Object[]{statement});
                return (J.Try)this.maybeAutoFormat((J)tryWithResources, (J)tryWithResources.withBody(this.findSuccessorStatements(statement, block)), ctx);
            }

            private @Nullable String getMockedClassName(J.MethodInvocation methodInvocation) {
                JavaType.FullyQualified mockedClass;
                JavaType.Parameterized type = TypeUtils.asParameterized((JavaType)methodInvocation.getType());
                if (type != null && type.getTypeParameters().size() == 1 && (mockedClass = TypeUtils.asFullyQualified((JavaType)((JavaType)type.getTypeParameters().get(0)))) != null) {
                    return mockedClass.getClassName();
                }
                return null;
            }

            private boolean shouldUseTryWithResources(@Nullable Statement statement) {
                if (statement instanceof J.VariableDeclarations) {
                    J.VariableDeclarations varDecl = (J.VariableDeclarations)statement;
                    return MOCK_STATIC_MATCHER.matches(((J.VariableDeclarations.NamedVariable)varDecl.getVariables().get(0)).getInitializer());
                }
                if (statement instanceof J.Assignment) {
                    J.Assignment assignment = (J.Assignment)statement;
                    return MOCK_STATIC_MATCHER.matches(assignment.getAssignment());
                }
                if (statement instanceof J.MethodInvocation) {
                    return MOCK_STATIC_MATCHER.matches((MethodCall)((J.MethodInvocation)statement));
                }
                return false;
            }

            private J.Block findSuccessorStatements(Statement statement, J.Block block) {
                ArrayList<Statement> successors = new ArrayList<Statement>();
                boolean found = false;
                for (Statement successor : block.getStatements()) {
                    if (found) {
                        successors.add(successor);
                    }
                    found = found || successor == statement;
                }
                return new J.Block(Tree.randomId(), Space.EMPTY, Markers.EMPTY, new JRightPadded((Object)false, Space.EMPTY, Markers.EMPTY), Collections.emptyList(), Space.format((String)" ")).withStatements(successors);
            }
        });
    }

    private static class DeclareMockVarAndClose
    extends JavaIsoVisitor<ExecutionContext> {
        private final String varName;
        private final String mockedClassName;
        private final boolean isStatic;
        private boolean closed = false;

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = classDecl;
            if (!VariableNameUtils.findNamesInScope((Cursor)this.getCursor()).contains(this.varName)) {
                String modifier = this.isStatic ? "static " : "";
                String varTemplate = "private " + modifier + "MockedStatic<" + this.mockedClassName + "> " + this.varName + ";";
                cd = (J.ClassDeclaration)JavaTemplate.builder((String)varTemplate).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core-5"})).imports(new String[]{"org.mockito.MockedStatic"}).build().apply(this.getCursor(), classDecl.getBody().getCoordinates().firstStatement(), new Object[0]);
            }
            cd = super.visitClassDeclaration(cd, (Object)ctx);
            if (this.closed) {
                return cd;
            }
            String methodName = this.tearDownMethodName(cd);
            String methodTemplate = String.format("%s void %s() { %s.close(); }", this.isStatic ? "@AfterAll public static" : "@AfterEach public", methodName, this.varName);
            return (J.ClassDeclaration)JavaTemplate.builder((String)methodTemplate).contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5"})).imports(new String[]{"org.junit.jupiter.api.AfterEach", "org.junit.jupiter.api.AfterAll"}).build().apply(this.updateCursor((Tree)cd), classDecl.getBody().getCoordinates().lastStatement(), new Object[0]);
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDecl, ExecutionContext ctx) {
            J.MethodDeclaration md = super.visitMethodDeclaration(methodDecl, (Object)ctx);
            if (this.closed) {
                return md;
            }
            AnnotationMatcher annotationMatcher = this.isStatic ? AFTER_ALL_MATCHER : AFTER_EACH_MATCHER;
            boolean matched = ((AtomicBoolean)Traits.annotated((AnnotationMatcher)annotationMatcher).asVisitor((a, found) -> {
                found.set(true);
                return a.getTree();
            }).reduce((Tree)md, (Object)new AtomicBoolean())).get();
            if (!matched) {
                return md;
            }
            this.closed = true;
            return (J.MethodDeclaration)JavaTemplate.builder((String)(this.varName + ".close()")).contextSensitive().build().apply(this.updateCursor((Tree)md), md.getBody().getCoordinates().lastStatement(), new Object[0]);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, ExecutionContext ctx) {
            String selector;
            if (methodInvocation.getSelect() instanceof J.Identifier && (selector = ((J.Identifier)methodInvocation.getSelect()).getSimpleName()).equals(this.varName) && methodInvocation.getSimpleName().equals("close")) {
                this.closed = true;
            }
            return super.visitMethodInvocation(methodInvocation, (Object)ctx);
        }

        private String tearDownMethodName(J.ClassDeclaration cd) {
            String methodName = "tearDown";
            int suffix = 0;
            String updatedMethodName = methodName;
            for (Statement st : cd.getBody().getStatements()) {
                if (!(st instanceof J.MethodDeclaration) || !((J.MethodDeclaration)st).getSimpleName().equals(updatedMethodName)) continue;
                updatedMethodName = methodName + suffix++;
            }
            return updatedMethodName;
        }

        @ConstructorProperties(value={"varName", "mockedClassName", "isStatic"})
        @Generated
        public DeclareMockVarAndClose(String varName, String mockedClassName, boolean isStatic) {
            this.varName = varName;
            this.mockedClassName = mockedClassName;
            this.isStatic = isStatic;
        }
    }
}

