/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;

public class TimeoutRuleToClassAnnotation
extends Recipe {
    private static final MethodMatcher TIMEOUT_CONSTRUCTOR_MATCHER = new MethodMatcher("org.junit.rules.Timeout <constructor>(..)");
    private static final MethodMatcher MILLIS_SECONDS_MATCHER = new MethodMatcher("org.junit.rules.Timeout *(long)");

    public String getDisplayName() {
        return "JUnit 4 `@Rule Timeout` to JUnit Jupiter's `Timeout`";
    }

    public String getDescription() {
        return "Replace usages of JUnit 4's `@Rule Timeout` with JUnit 5 `Timeout` class annotation.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.rules.Timeout", Boolean.valueOf(false)), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                AtomicReference<@Nullable V> initializer = new AtomicReference();
                cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                    List variables;
                    if (statement instanceof J.VariableDeclarations && TypeUtils.isOfClassType((JavaType)((J.VariableDeclarations)statement).getTypeExpression().getType(), (String)"org.junit.rules.Timeout") && !(variables = ((J.VariableDeclarations)statement).getVariables()).isEmpty()) {
                        Expression timeoutInitializer = ((J.VariableDeclarations.NamedVariable)variables.get(0)).getInitializer();
                        if (TIMEOUT_CONSTRUCTOR_MATCHER.matches(timeoutInitializer) || MILLIS_SECONDS_MATCHER.matches(timeoutInitializer)) {
                            initializer.set(timeoutInitializer);
                            return null;
                        }
                    }
                    return statement;
                })));
                Expression initializerValue = (Expression)initializer.get();
                if (initializerValue != null) {
                    this.maybeRemoveImport("org.junit.Rule");
                    this.maybeRemoveImport("org.junit.rules.Timeout");
                    return this.insertTimeoutAnnotation(initializerValue, cd, ctx);
                }
                return cd;
            }

            private J.ClassDeclaration insertTimeoutAnnotation(Expression ex, J.ClassDeclaration cd, ExecutionContext ctx) {
                Object[] params;
                String template;
                if (TIMEOUT_CONSTRUCTOR_MATCHER.matches(ex)) {
                    List arguments = ((J.NewClass)ex).getArguments();
                    if (arguments.size() == 2) {
                        template = "@Timeout(value = #{any(long)}, unit = #{any(java.util.concurrent.TimeUnit)})";
                        params = new Object[]{arguments.get(0), arguments.get(1)};
                    } else {
                        template = "@Timeout(value = #{any(long)}, unit = TimeUnit.MILLISECONDS)";
                        params = new Object[]{arguments.get(0)};
                    }
                } else if (MILLIS_SECONDS_MATCHER.matches(ex)) {
                    String simpleName = ((J.MethodInvocation)ex).getSimpleName();
                    String units = simpleName.equals("millis") ? "MILLISECONDS" : "SECONDS";
                    template = "@Timeout(value = #{any(long)}, unit = TimeUnit." + units + ")";
                    params = new Object[]{((J.MethodInvocation)ex).getArguments().get(0)};
                } else {
                    return cd;
                }
                this.maybeAddImport("org.junit.jupiter.api.Timeout");
                this.maybeAddImport("java.util.concurrent.TimeUnit");
                return (J.ClassDeclaration)JavaTemplate.builder((String)template).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "hamcrest-3"})).imports(new String[]{"org.junit.jupiter.api.Timeout", "java.util.concurrent.TimeUnit"}).build().apply(this.updateCursor((Tree)cd), cd.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), params);
            }
        });
    }
}

