/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJLongRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Adopt AssertJ Long Assertions";
    }

    public String getDescription() {
        return "Adopt AssertJ Long Assertions. Favor semantically explicit methods (e.g. `myLong.isZero()` over `myLong.isEqualTo(0)`).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractLongAssertIsEqualToRecipe(), new AbstractLongAssertIsNotEqualToRecipe(), new AbstractLongAssertIsZeroRecipe(), new AbstractLongAssertIsNotZeroRecipe(), new AbstractLongAssertIsOneRecipe()});
    }

    @NullMarked
    public static class AbstractLongAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isCloseTo` with `isEqualTo`";
        }

        public String getDescription() {
            return "Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isCloseTo(#{n:any(long)}, org.assertj.core.data.Offset.offset(0L))").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isEqualTo(#{n:any(long)})").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isCloseTo(#{n:any(long)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isEqualTo(#{n:any(long)})").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractLongAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotCloseTo` with `isNotEqualTo`";
        }

        public String getDescription() {
            return "Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotCloseTo(#{n:any(long)}, org.assertj.core.data.Offset.offset(0L))").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset");
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotEqualTo(#{n:any(long)})").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotCloseTo(#{n:any(long)}, org.assertj.core.data.Percentage.withPercentage(0))").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage");
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotEqualTo(#{n:any(long)})").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isNotCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractLongAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(0)` with `isZero()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(0)` with `isZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isEqualTo(0)").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isZero()").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractLongAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`";
        }

        public String getDescription() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotEqualTo(0)").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isNotZero()").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isNotEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractLongAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(1)` with `isOne()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(1)` with `isOne()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isEqualTo(1)").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{longAssert:any(org.assertj.core.api.AbstractLongAssert<?>)}.isOne()").bindType("org.assertj.core.api.AbstractLongAssert<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

