/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.cleanup;

import java.util.Collection;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NullMarked
public class AssertLiteralBooleanRemovedRecipe
extends Recipe {
    public String getDisplayName() {
        return "Remove JUnit `assertTrue(true)` and `assertFalse(false)`";
    }

    public String getDescription() {
        return "These assertions are redundant and do not provide any value. They can be safely removed.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            JavaTemplate assertFalseBefore;
            JavaTemplate assertTrueBefore;
            JavaTemplate assertFalseBefore0;
            JavaTemplate assertTrueBefore0;

            public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (this.assertFalseBefore == null) {
                    this.assertFalseBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(false, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                }
                if ((matcher = this.assertFalseBefore.matcher(this.getCursor())).find()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                    return null;
                }
                if (this.assertFalseBefore0 == null) {
                    this.assertFalseBefore0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertFalse(false);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                }
                if ((matcher = this.assertFalseBefore0.matcher(this.getCursor())).find()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertFalse");
                    return null;
                }
                if (this.assertTrueBefore == null) {
                    this.assertTrueBefore = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(true, #{message:any(java.lang.String)});").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                }
                if ((matcher = this.assertTrueBefore.matcher(this.getCursor())).find()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                    return null;
                }
                if (this.assertTrueBefore0 == null) {
                    this.assertTrueBefore0 = JavaTemplate.builder((String)"org.junit.jupiter.api.Assertions.assertTrue(true);").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                }
                if ((matcher = this.assertTrueBefore0.matcher(this.getCursor())).find()) {
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions");
                    this.maybeRemoveImport("org.junit.jupiter.api.Assertions.assertTrue");
                    return null;
                }
                return super.visitMethodInvocation(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.junit.jupiter.api.Assertions assertFalse(..)", true), new UsesMethod("org.junit.jupiter.api.Assertions assertTrue(..)", true)}), (TreeVisitor)javaVisitor);
    }
}

