/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.RemoveAnnotationVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class ParameterizedRunnerToParameterized
extends Recipe {
    private static final AnnotationMatcher RUN_WITH_PARAMETERS = new AnnotationMatcher("@org.junit.runner.RunWith(org.junit.runners.Parameterized.class)");
    private static final AnnotationMatcher JUNIT_TEST = new AnnotationMatcher("@org.junit.Test");
    private static final AnnotationMatcher JUPITER_TEST = new AnnotationMatcher("@org.junit.jupiter.api.Test");
    private static final AnnotationMatcher PARAMETERS = new AnnotationMatcher("@org.junit.runners.Parameterized$Parameters");
    private static final AnnotationMatcher BEFORE = new AnnotationMatcher("@org.junit.Before");
    private static final AnnotationMatcher PARAMETER = new AnnotationMatcher("@org.junit.runners.Parameterized$Parameter");
    private static final AnnotationMatcher PARAMETERIZED_TEST = new AnnotationMatcher("@org.junit.jupiter.params.ParameterizedTest");
    private static final String PARAMETERS_ANNOTATION_ARGUMENTS = "parameters-annotation-args";
    private static final String CONSTRUCTOR_ARGUMENTS = "constructor-args";
    private static final String FIELD_INJECTION_ARGUMENTS = "field-injection-args";
    private static final String PARAMETERS_METHOD_NAME = "parameters-method-name";
    private static final String BEFORE_METHOD_NAME = "before-method-name";

    public String getDisplayName() {
        return "JUnit 4 `@RunWith(Parameterized.class)` to JUnit Jupiter parameterized tests";
    }

    public String getDescription() {
        return "Convert JUnit 4 parameterized runner the JUnit Jupiter parameterized test equivalent.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesType("org.junit.runners.Parameterized", Boolean.valueOf(false)), (TreeVisitor)new ParameterizedRunnerVisitor());
    }

    private static class ParameterizedRunnerVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private ParameterizedRunnerVisitor() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            Map params = (Map)this.getCursor().pollMessage(classDecl.getId().toString());
            if (params == null) return cd;
            String parametersMethodName = (String)params.get(ParameterizedRunnerToParameterized.PARAMETERS_METHOD_NAME);
            List parametersAnnotationArguments = (List)params.get(ParameterizedRunnerToParameterized.PARAMETERS_ANNOTATION_ARGUMENTS);
            List constructorParams = (List)params.get(ParameterizedRunnerToParameterized.CONSTRUCTOR_ARGUMENTS);
            Map fieldInjectionParams = (Map)params.get(ParameterizedRunnerToParameterized.FIELD_INJECTION_ARGUMENTS);
            String initMethodName = "init" + cd.getSimpleName();
            String beforeMethodName = params.getOrDefault(ParameterizedRunnerToParameterized.BEFORE_METHOD_NAME, null);
            if (parametersMethodName != null && constructorParams != null) {
                if (constructorParams.stream().anyMatch(J.VariableDeclarations.class::isInstance)) {
                    this.doAfterVisit((TreeVisitor)new ParameterizedRunnerToParameterizedTestsVisitor(classDecl, parametersMethodName, initMethodName, parametersAnnotationArguments, constructorParams, true, beforeMethodName, ctx));
                    return cd;
                }
            }
            if (parametersMethodName == null) return cd;
            if (fieldInjectionParams == null) return cd;
            ArrayList<Statement> fieldParams = new ArrayList<Statement>(fieldInjectionParams.values());
            this.doAfterVisit((TreeVisitor)new ParameterizedRunnerToParameterizedTestsVisitor(classDecl, parametersMethodName, initMethodName, parametersAnnotationArguments, fieldParams, false, beforeMethodName, ctx));
            return cd;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            Cursor classDeclCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            Map params = (Map)classDeclCursor.computeMessageIfAbsent(((J.ClassDeclaration)classDeclCursor.getValue()).getId().toString(), v -> new HashMap());
            if (m.isConstructor()) {
                params.put(ParameterizedRunnerToParameterized.CONSTRUCTOR_ARGUMENTS, m.getParameters());
            }
            for (J.Annotation annotation : ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor())) {
                if (PARAMETERS.matches(annotation)) {
                    params.put(ParameterizedRunnerToParameterized.PARAMETERS_ANNOTATION_ARGUMENTS, annotation.getArguments());
                    params.put(ParameterizedRunnerToParameterized.PARAMETERS_METHOD_NAME, method.getSimpleName());
                    break;
                }
                if (!BEFORE.matches(annotation)) continue;
                params.put(ParameterizedRunnerToParameterized.BEFORE_METHOD_NAME, method.getSimpleName());
            }
            return m;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            Cursor classDeclCursor = this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance);
            J.Annotation parameterAnnotation = null;
            Integer position = 0;
            for (J.Annotation leadingAnnotation : ((AnnotationService)this.service(AnnotationService.class)).getAllAnnotations(this.getCursor())) {
                if (!PARAMETER.matches(leadingAnnotation)) continue;
                parameterAnnotation = leadingAnnotation;
                if (parameterAnnotation.getArguments() == null || parameterAnnotation.getArguments().get(0) instanceof J.Empty) break;
                J positionArg = (J)parameterAnnotation.getArguments().get(0);
                if (positionArg instanceof J.Assignment) {
                    position = (Integer)((J.Literal)((J.Assignment)positionArg).getAssignment()).getValue();
                    break;
                }
                position = (Integer)((J.Literal)positionArg).getValue();
                break;
            }
            if (parameterAnnotation != null) {
                J.VariableDeclarations variableForInitMethod = variableDeclarations.withLeadingAnnotations(new ArrayList()).withModifiers(new ArrayList()).withPrefix(Space.EMPTY);
                if (variableForInitMethod.getTypeExpression() != null) {
                    variableForInitMethod = variableForInitMethod.withTypeExpression((TypeTree)variableForInitMethod.getTypeExpression().withPrefix(Space.EMPTY).withComments(new ArrayList()));
                }
                Map params = (Map)classDeclCursor.computeMessageIfAbsent(((J.ClassDeclaration)classDeclCursor.getValue()).getId().toString(), v -> new HashMap());
                params.computeIfAbsent(ParameterizedRunnerToParameterized.FIELD_INJECTION_ARGUMENTS, v -> new TreeMap()).put(position, variableForInitMethod);
            }
            return variableDeclarations;
        }
    }

    private static class ParameterizedRunnerToParameterizedTestsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final J.ClassDeclaration scope;
        private final String initMethodName;
        private final List<Statement> parameterizedTestMethodParameters;
        private final @Nullable List<Expression> parameterizedTestAnnotationParameters;
        private final String initStatementParamString;
        private final JavaTemplate parameterizedTestTemplate;
        private final JavaTemplate methodSourceTemplate;
        private final JavaTemplate initMethodStatementTemplate;
        private final @Nullable JavaTemplate initMethodDeclarationTemplate;

        public ParameterizedRunnerToParameterizedTestsVisitor(J.ClassDeclaration scope, String parametersMethodName, String initMethodName, @Nullable List<Expression> parameterizedTestAnnotationParameters, List<Statement> parameterizedTestMethodParameters, boolean isConstructorInjection, @Nullable String beforeMethodName, ExecutionContext ctx) {
            this.scope = scope;
            this.initMethodName = initMethodName;
            this.parameterizedTestMethodParameters = parameterizedTestMethodParameters.stream().map(mp -> mp.withPrefix(Space.EMPTY).withComments(new ArrayList())).map(Statement.class::cast).collect(Collectors.toList());
            this.initStatementParamString = parameterizedTestMethodParameters.stream().filter(J.VariableDeclarations.class::isInstance).map(J.VariableDeclarations.class::cast).map(v -> ((J.VariableDeclarations.NamedVariable)v.getVariables().get(0)).getSimpleName()).collect(Collectors.joining(", "));
            this.parameterizedTestAnnotationParameters = parameterizedTestAnnotationParameters;
            String parameterizedTestAnnotationTemplate = parameterizedTestAnnotationParameters != null ? "@ParameterizedTest(#{any()})" : "@ParameterizedTest";
            JavaParser.Builder javaParserBuilder = JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5", "junit-jupiter-params-5"});
            this.parameterizedTestTemplate = JavaTemplate.builder((String)parameterizedTestAnnotationTemplate).javaParser(javaParserBuilder).imports(new String[]{"org.junit.jupiter.params.ParameterizedTest"}).build();
            this.methodSourceTemplate = JavaTemplate.builder((String)("@MethodSource(\"" + parametersMethodName + "\")")).javaParser(javaParserBuilder).imports(new String[]{"org.junit.jupiter.params.provider.MethodSource"}).build();
            this.initMethodStatementTemplate = JavaTemplate.builder((String)(initMethodName + "(#{});")).contextSensitive().javaParser(javaParserBuilder).build();
            if (!isConstructorInjection) {
                StringBuilder initMethodTemplate = new StringBuilder("public void ").append(initMethodName).append("() {\n");
                ArrayList<String> initStatementParams = new ArrayList<String>();
                for (Statement parameterizedTestMethodParameter : parameterizedTestMethodParameters) {
                    J.VariableDeclarations vd = (J.VariableDeclarations)parameterizedTestMethodParameter;
                    if (vd.getTypeExpression() != null && vd.getVariables().size() == 1) {
                        initStatementParams.add(((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getSimpleName());
                        continue;
                    }
                    throw new AssertionError((Object)("Expected VariableDeclarations with TypeExpression and single Variable, got [" + parameterizedTestMethodParameter + "]"));
                }
                for (String p : initStatementParams) {
                    initMethodTemplate.append("    this.").append(p).append(" = ").append(p).append(";\n");
                }
                if (beforeMethodName != null) {
                    initMethodTemplate.append("    this.").append(beforeMethodName).append("();\n");
                }
                initMethodTemplate.append("}");
                this.initMethodDeclarationTemplate = JavaTemplate.builder((String)initMethodTemplate.toString()).contextSensitive().javaParser(javaParserBuilder).build();
            } else {
                this.initMethodDeclarationTemplate = null;
            }
        }

        public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
            J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)ctx);
            if (c != cu) {
                this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(PARAMETERS));
                this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(PARAMETER));
                this.doAfterVisit((TreeVisitor)new RemoveAnnotationVisitor(RUN_WITH_PARAMETERS));
                this.maybeRemoveImport("org.junit.Test");
                this.maybeRemoveImport("org.junit.runner.RunWith");
                this.maybeRemoveImport("org.junit.runners.Parameterized");
                this.maybeRemoveImport("org.junit.runners.Parameterized.Parameters");
                this.maybeRemoveImport("org.junit.runners.Parameterized.Parameter");
                this.maybeRemoveImport("org.junit.jupiter.api.Test");
                this.maybeAddImport("org.junit.jupiter.params.ParameterizedTest");
                this.maybeAddImport("org.junit.jupiter.params.provider.MethodSource");
            }
            return c;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            Set fieldNames;
            J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
            if (!this.scope.isScope((Tree)classDecl)) {
                return cd;
            }
            if (this.initMethodDeclarationTemplate != null) {
                cd = (J.ClassDeclaration)this.initMethodDeclarationTemplate.apply(this.updateCursor((Tree)cd), cd.getBody().getCoordinates().lastStatement(), new Object[0]);
                J.Block finalBody = cd.getBody();
                cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), stmt -> {
                    J.MethodDeclaration md;
                    if (stmt instanceof J.MethodDeclaration && (md = (J.MethodDeclaration)stmt).getName().getSimpleName().equals(this.initMethodName)) {
                        J.Block body = md.getBody();
                        return ((J.MethodDeclaration)this.autoFormat((J)md.withParameters(this.parameterizedTestMethodParameters).withBody(null), ctx, new Cursor(this.getCursor(), (Object)finalBody))).withBody(body);
                    }
                    return stmt;
                })));
            }
            if ((fieldNames = (Set)this.getCursor().pollMessage("INIT_VARS")) != null && !fieldNames.isEmpty()) {
                J.Block finalBody = cd.getBody();
                cd = cd.withBody(cd.getBody().withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                    J.VariableDeclarations varDecls;
                    if (statement instanceof J.VariableDeclarations && (varDecls = (J.VariableDeclarations)statement).getVariables().stream().anyMatch(it -> fieldNames.contains(it.getSimpleName())) && varDecls.hasModifier(J.Modifier.Type.Final)) {
                        varDecls = varDecls.withModifiers(ListUtils.map((List)varDecls.getModifiers(), mod -> mod.getType() == J.Modifier.Type.Final ? null : mod));
                        statement = (Statement)this.maybeAutoFormat((J)statement, (J)varDecls, ctx, new Cursor(this.getCursor(), (Object)finalBody));
                    }
                    return statement;
                })));
            }
            return cd;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations vdecls = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            if (!this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).isScopeInPath((Tree)this.scope)) {
                return vdecls;
            }
            AtomicReference annoPrefix = new AtomicReference();
            vdecls = vdecls.withLeadingAnnotations(ListUtils.map((List)vdecls.getLeadingAnnotations(), anno -> {
                if (PARAMETER.matches(anno)) {
                    annoPrefix.set(anno.getPrefix());
                    return null;
                }
                return anno;
            }));
            if (annoPrefix.get() != null) {
                vdecls = vdecls.withPrefix((Space)annoPrefix.get());
            }
            return vdecls;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            if (!this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).isScopeInPath((Tree)this.scope)) {
                return m;
            }
            m = m.withLeadingAnnotations(ListUtils.map((List)m.getLeadingAnnotations(), annotation -> {
                if (JUPITER_TEST.matches(annotation) || JUNIT_TEST.matches(annotation)) {
                    List annotationComments = annotation.getComments();
                    annotation = this.parameterizedTestAnnotationParameters == null ? (J.Annotation)this.parameterizedTestTemplate.apply(new Cursor(this.getCursor(), annotation), annotation.getCoordinates().replace(), new Object[0]) : (J.Annotation)this.parameterizedTestTemplate.apply(new Cursor(this.getCursor(), annotation), annotation.getCoordinates().replace(), new Object[]{this.parameterizedTestAnnotationParameters.get(0)});
                    if (!annotationComments.isEmpty()) {
                        annotation = (J.Annotation)annotation.withComments(annotationComments);
                    }
                }
                return annotation;
            }));
            if (m.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)PARAMETERIZED_TEST).matches(arg_0))) {
                m = (J.MethodDeclaration)this.methodSourceTemplate.apply(this.updateCursor((Tree)m), m.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                assert (m.getBody() != null);
                JavaCoordinates newStatementCoordinates = !m.getBody().getStatements().isEmpty() ? ((Statement)m.getBody().getStatements().get(0)).getCoordinates().before() : m.getBody().getCoordinates().lastStatement();
                m = (J.MethodDeclaration)this.initMethodStatementTemplate.apply(this.updateCursor((Tree)m), newStatementCoordinates, new Object[]{this.initStatementParamString});
                m = (J.MethodDeclaration)this.maybeAutoFormat((J)m, (J)m.withParameters(this.parameterizedTestMethodParameters), (J)m.getName(), ctx, this.getCursor().getParentTreeCursor());
            }
            if (this.initMethodDeclarationTemplate == null && m.isConstructor()) {
                m = m.withName(m.getName().withSimpleName(this.initMethodName));
                if ((m = (J.MethodDeclaration)this.maybeAutoFormat((J)m, (J)m.withReturnTypeExpression((TypeTree)new J.Primitive(Tree.randomId(), Space.EMPTY, Markers.EMPTY, JavaType.Primitive.Void)), (J)m.getName(), ctx, this.getCursor().getParentTreeCursor())).getBody() != null) {
                    Set fieldNames = m.getBody().getStatements().stream().filter(J.Assignment.class::isInstance).map(J.Assignment.class::cast).map(it -> {
                        if (it.getVariable() instanceof J.FieldAccess) {
                            return ((J.FieldAccess)it.getVariable()).getName().getSimpleName();
                        }
                        return it.getVariable() instanceof J.Identifier ? ((J.Identifier)it.getVariable()).getSimpleName() : null;
                    }).collect(Collectors.toSet());
                    this.getCursor().dropParentUntil(J.ClassDeclaration.class::isInstance).putMessage("INIT_VARS", fieldNames);
                    m = m.withBody(m.getBody().withStatements(ListUtils.mapFirst((List)m.getBody().getStatements(), stmt -> stmt instanceof J.MethodInvocation && "super".equals(((J.MethodInvocation)stmt).getSimpleName()) ? null : stmt)));
                }
            }
            return m;
        }
    }
}

