/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.util.ArrayList;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.testing.hamcrest.RemoveNotMatcherVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class HamcrestInstanceOfToJUnit5
extends Recipe {
    private static final MethodMatcher INSTANCE_OF_MATCHER = new MethodMatcher("org.hamcrest.Matchers instanceOf(..)");
    private static final MethodMatcher IS_A_MATCHER = new MethodMatcher("org.hamcrest.Matchers isA(..)");
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(.., org.hamcrest.Matcher)");

    public String getDisplayName() {
        return "Migrate from Hamcrest `instanceOf` matcher to JUnit 5";
    }

    public String getDescription() {
        return "Migrate from Hamcrest `instanceOf` and `isA` matcher to JUnit5 `assertInstanceOf` assertion.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor preconditions = Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(ASSERT_THAT_MATCHER), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(INSTANCE_OF_MATCHER), new UsesMethod(IS_A_MATCHER)})});
        return Preconditions.check((TreeVisitor)preconditions, (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
                if (ASSERT_THAT_MATCHER.matches((MethodCall)mi)) {
                    Expression hamcrestMatcher;
                    Expression examinedObject;
                    Expression reason;
                    if (mi.getArguments().size() == 2) {
                        reason = null;
                        examinedObject = (Expression)mi.getArguments().get(0);
                        hamcrestMatcher = (Expression)mi.getArguments().get(1);
                    } else if (mi.getArguments().size() == 3) {
                        reason = (Expression)mi.getArguments().get(0);
                        examinedObject = (Expression)mi.getArguments().get(1);
                        hamcrestMatcher = (Expression)mi.getArguments().get(2);
                    } else {
                        return mi;
                    }
                    J.MethodInvocation matcherInvocation = (J.MethodInvocation)hamcrestMatcher;
                    while ("not".equals(matcherInvocation.getSimpleName())) {
                        this.maybeRemoveImport("org.hamcrest.Matchers.not");
                        this.maybeRemoveImport("org.hamcrest.CoreMatchers.not");
                        matcherInvocation = (J.MethodInvocation)new RemoveNotMatcherVisitor().visit((Tree)matcherInvocation, ctx);
                    }
                    if (INSTANCE_OF_MATCHER.matches((MethodCall)matcherInvocation) || IS_A_MATCHER.matches((MethodCall)matcherInvocation)) {
                        boolean logicalContext = RemoveNotMatcherVisitor.getLogicalContext(matcherInvocation, ctx);
                        String templateString = (logicalContext ? "assertInstanceOf(#{any(java.lang.Class)}, #{any(java.lang.Object)}" : "assertFalse(#{any(java.lang.Class)}.isAssignableFrom(#{any(java.lang.Object)}.getClass())") + (reason == null ? ")" : ", #{any(java.lang.String)})");
                        JavaTemplate template = JavaTemplate.builder((String)templateString).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"junit-jupiter-api-5.9"})).staticImports(new String[]{"org.junit.jupiter.api.Assertions." + (logicalContext ? "assertInstanceOf" : "assertFalse")}).build();
                        this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
                        this.maybeRemoveImport("org.hamcrest.Matchers.instanceOf");
                        this.maybeRemoveImport("org.hamcrest.CoreMatchers.instanceOf");
                        this.maybeRemoveImport("org.hamcrest.Matchers.isA");
                        this.maybeRemoveImport("org.hamcrest.CoreMatchers.isA");
                        this.maybeAddImport("org.junit.jupiter.api.Assertions", logicalContext ? "assertInstanceOf" : "assertFalse");
                        ArrayList<Expression> arguments = new ArrayList<Expression>();
                        arguments.add((Expression)matcherInvocation.getArguments().get(0));
                        arguments.add(examinedObject);
                        if (reason != null) {
                            arguments.add(reason);
                        }
                        return (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), arguments.toArray());
                    }
                }
                return super.visitMethodInvocation(mi, (Object)ctx);
            }
        });
    }
}

