/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.security.InvalidParameterException;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

class RemoveNotMatcherVisitor
extends JavaIsoVisitor<ExecutionContext> {
    static final MethodMatcher NOT_MATCHER = new MethodMatcher("org.hamcrest.Matchers not(..)");

    RemoveNotMatcherVisitor() {
    }

    public static boolean getLogicalContext(J.MethodInvocation mi, ExecutionContext ctx) throws InvalidParameterException {
        Object msg = ctx.getMessage(mi.toString());
        if (msg == null) {
            return true;
        }
        if (msg instanceof Boolean) {
            return (Boolean)msg;
        }
        throw new InvalidParameterException();
    }

    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation mi, ExecutionContext ctx) {
        if (NOT_MATCHER.matches((MethodCall)mi)) {
            J.MethodInvocation result;
            boolean logicalContext = ctx.pollMessage(mi.toString()) != null ? (Boolean)ctx.getMessage(mi.toString()) : true;
            this.maybeRemoveImport("org.hamcrest.Matchers.not");
            if (Objects.requireNonNull(((Expression)mi.getArguments().get(0)).getType()).toString().startsWith("org.hamcrest")) {
                result = (J.MethodInvocation)((Expression)mi.getArguments().get(0)).withPrefix(mi.getPrefix());
            } else {
                JavaTemplate template = JavaTemplate.builder((String)"equalTo(#{any(java.lang.Object)})").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"hamcrest-2.2"})).staticImports(new String[]{"org.hamcrest.Matchers.equalTo"}).build();
                this.maybeAddImport("org.hamcrest.Matchers", "equalTo");
                result = (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getArguments().get(0)});
            }
            ctx.putMessage(result.toString(), (Object)(!logicalContext ? 1 : 0));
            return result;
        }
        if (ctx.pollMessage(mi.toString()) == null) {
            ctx.putMessage(mi.toString(), (Object)true);
        }
        return super.visitMethodInvocation(mi, (Object)ctx);
    }
}

