/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeUtils;

public final class GradleUseJunitJupiter
extends Recipe {
    private static final String USE_JUNIT_PLATFORM_PATTERN = "org.gradle.api.tasks.testing.Test useJUnitPlatform()";
    private static final MethodMatcher USE_JUNIT_PLATFORM_MATCHER = new MethodMatcher("org.gradle.api.tasks.testing.Test useJUnitPlatform()");
    private static final MethodMatcher USE_JUNIT4_MATCHER = new MethodMatcher("org.gradle.api.tasks.testing.Test useJUnit()");
    private static final MethodMatcher USE_JUNIT4_ALTERNATE_MATCHER = new MethodMatcher("RewriteTestSpec useJUnit()");
    private static final MethodMatcher TEST_DSL_MATCHER = new MethodMatcher("RewriteGradleProject test(..)");

    public String getDisplayName() {
        return "Gradle `Test` use JUnit Jupiter";
    }

    public String getDescription() {
        return "By default Gradle's `Test` tasks use JUnit 4. Gradle `Test` tasks must be configured with `useJUnitPlatform()` to run JUnit Jupiter tests. This recipe adds the `useJUnitPlatform()` method call to the `Test` task configuration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        GroovyIsoVisitor<ExecutionContext> visitor = new GroovyIsoVisitor<ExecutionContext>(){
            GradleProject gp;

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit compilationUnit, ExecutionContext ctx) {
                this.gp = compilationUnit.getMarkers().findFirst(GradleProject.class).orElse(null);
                if (this.gp == null) {
                    return compilationUnit;
                }
                if (this.gp.getPlugins().stream().noneMatch(plugin -> plugin.getFullyQualifiedClassName().contains("org.gradle.api.plugins.JavaBasePlugin"))) {
                    return compilationUnit;
                }
                if (GradleUseJunitJupiter.containsJUnitPlatformInvocation(compilationUnit)) {
                    return compilationUnit;
                }
                G.CompilationUnit cu = (G.CompilationUnit)new UpdateExistingUseJunit4().visitNonNull((Tree)compilationUnit, ctx, Objects.requireNonNull(this.getCursor().getParent()));
                if (cu != compilationUnit) {
                    return cu;
                }
                if ((cu = (G.CompilationUnit)new AddJUnitPlatformToExistingTestDsl().visitNonNull((Tree)cu, ctx, Objects.requireNonNull(this.getCursor().getParent()))) != compilationUnit) {
                    return cu;
                }
                return (G.CompilationUnit)new AddUseJUnitPlatform().visitNonNull((Tree)cu, ctx, this.getCursor().getParent());
            }
        };
        return Preconditions.check((TreeVisitor)new IsBuildGradle(), (TreeVisitor)visitor);
    }

    private static boolean containsJUnitPlatformInvocation(G.CompilationUnit cu) {
        AtomicBoolean found = new AtomicBoolean(false);
        new GroovyIsoVisitor<AtomicBoolean>(){

            public @Nullable J preVisit(J tree, AtomicBoolean found) {
                if (found.get()) {
                    this.stopAfterPreVisit();
                    return tree;
                }
                return (J)super.preVisit((Tree)tree, (Object)found);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, AtomicBoolean found) {
                if ("useJUnitPlatform".equals(m.getSimpleName()) && (m.getArguments().isEmpty() || m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Empty)) {
                    found.set(true);
                    return m;
                }
                return super.visitMethodInvocation(m, (Object)found);
            }
        }.visit((Tree)cu, (Object)found);
        return found.get();
    }

    @Generated
    public GradleUseJunitJupiter() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleUseJunitJupiter()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleUseJunitJupiter)) {
            return false;
        }
        GradleUseJunitJupiter other = (GradleUseJunitJupiter)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof GradleUseJunitJupiter;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class AddJUnitPlatformAsLastStatementInClosure
    extends GroovyIsoVisitor<ExecutionContext> {
        private AddJUnitPlatformAsLastStatementInClosure() {
        }

        public J.Lambda visitLambda(J.Lambda l, ExecutionContext ctx) {
            if (!(l.getBody() instanceof J.Block)) {
                return l;
            }
            G.CompilationUnit cu = (G.CompilationUnit)GradleParser.builder().build().parse(new String[]{"plugins {\n    id 'java'\n}\ntasks.withType(Test) {\n    useJUnitPlatform()\n}"}).map(G.CompilationUnit.class::cast).collect(Collectors.toList()).get(0);
            J.MethodInvocation useJUnitPlatform = Optional.of((Statement)cu.getStatements().get(1)).map(J.MethodInvocation.class::cast).map(J.MethodInvocation::getArguments).map(args -> (Expression)args.get(1)).map(J.Lambda.class::cast).map(J.Lambda::getBody).map(J.Block.class::cast).map(J.Block::getStatements).map(statements -> (Statement)statements.get(0)).map(J.Return.class::cast).map(J.Return::getExpression).map(J.MethodInvocation.class::cast).orElse(null);
            if (useJUnitPlatform == null) {
                return l;
            }
            J.Block b = (J.Block)l.getBody();
            l = l.withBody((J)b.withStatements(ListUtils.concat((List)b.getStatements(), (Object)useJUnitPlatform)));
            return (J.Lambda)this.autoFormat((J)l, ctx, Objects.requireNonNull(this.getCursor().getParent()));
        }
    }

    private static class AddJUnitPlatformToExistingTestDsl
    extends GroovyIsoVisitor<ExecutionContext> {
        private AddJUnitPlatformToExistingTestDsl() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String mName;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            switch (mName = m.getSimpleName()) {
                case "test": {
                    if (m.getArguments().size() != 1 || !(m.getArguments().get(0) instanceof J.Lambda)) {
                        return m;
                    }
                    if (this.getCursor().getParentTreeCursor().firstEnclosing(J.MethodInvocation.class) == null) break;
                    return m;
                }
                case "named": {
                    if (m.getArguments().isEmpty()) {
                        return m;
                    }
                    if (!(m.getArguments().get(0) instanceof J.Literal) || !"test".equals(((J.Literal)m.getArguments().get(0)).getValue())) {
                        return m;
                    }
                    if (m.getArguments().get(m.getArguments().size() - 1) instanceof J.Lambda) break;
                    return m;
                }
                case "withType": {
                    if (m.getSelect() != null && TypeUtils.isOfClassType((JavaType)m.getSelect().getType(), (String)"org.gradle.api.tasks.TaskContainer") && m.getArguments().get(0) instanceof J.Identifier && "Test".equals(((J.Identifier)m.getArguments().get(0)).getSimpleName())) break;
                    return m;
                }
                case "configureEach": {
                    if (m.getArguments().size() != 1 || !(m.getArguments().get(0) instanceof J.Lambda)) {
                        return m;
                    }
                    if (m.getSelect() == null || !(m.getSelect() instanceof J.MethodInvocation)) {
                        return m;
                    }
                    J.MethodInvocation select = (J.MethodInvocation)m.getSelect();
                    if ("withType".equals(select.getSimpleName()) && select.getArguments().size() == 1 && select.getArguments().get(0) instanceof J.Identifier && "Test".equals(((J.Identifier)select.getArguments().get(0)).getSimpleName())) break;
                    return m;
                }
                default: {
                    return m;
                }
            }
            return (J.MethodInvocation)new AddJUnitPlatformAsLastStatementInClosure().visitNonNull((Tree)m, ctx, Objects.requireNonNull(this.getCursor().getParent()));
        }
    }

    private static class AddUseJUnitPlatform
    extends GroovyIsoVisitor<ExecutionContext> {
        private AddUseJUnitPlatform() {
        }

        public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
            G.CompilationUnit template = (G.CompilationUnit)GradleParser.builder().build().parse(new String[]{"plugins {\n    id 'java'\n}\ntasks.withType(Test).configureEach {\n    useJUnitPlatform()\n}"}).map(G.CompilationUnit.class::cast).collect(Collectors.toList()).get(0);
            J.MethodInvocation configureEachInvocation = (J.MethodInvocation)template.getStatements().get(1);
            return cu.withStatements(ListUtils.concat((List)cu.getStatements(), (Object)configureEachInvocation));
        }
    }

    private static class UpdateExistingUseJunit4
    extends GroovyIsoVisitor<ExecutionContext> {
        private UpdateExistingUseJunit4() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if ("useJUnit".equals(m.getSimpleName()) && (m.getArguments().isEmpty() || m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Empty)) {
                JavaType.Method useJUnitPlatformType = Optional.ofNullable(m.getMethodType()).map(JavaType.Method::getDeclaringType).flatMap(declaringType -> declaringType.getMethods().stream().filter(method1 -> method1.getName().equals("useJUnitPlatform")).findFirst()).orElse(null);
                return m.withName(m.getName().withSimpleName("useJUnitPlatform")).withMethodType(useJUnitPlatformType);
            }
            return m;
        }
    }
}

