/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.gradle.marker.GradleProject;
import org.openrewrite.groovy.GroovyIsoVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.tree.ParseError;

public final class GradleUseJunitJupiter
extends Recipe {
    private static final String USE_JUNIT_PLATFORM_PATTERN = "org.gradle.api.tasks.testing.Test useJUnitPlatform()";
    private static final MethodMatcher USE_JUNIT_PLATFORM_MATCHER = new MethodMatcher("org.gradle.api.tasks.testing.Test useJUnitPlatform()");
    private static final MethodMatcher USE_JUNIT4_MATCHER = new MethodMatcher("org.gradle.api.tasks.testing.Test useJUnit()");
    private static final MethodMatcher USE_JUNIT4_ALTERNATE_MATCHER = new MethodMatcher("RewriteTestSpec useJUnit()");
    private static final MethodMatcher TEST_DSL_MATCHER = new MethodMatcher("RewriteGradleProject test(..)");

    public String getDisplayName() {
        return "Gradle `Test` use JUnit Jupiter";
    }

    public String getDescription() {
        return "By default Gradle's `Test` tasks use JUnit 4. Gradle `Test` tasks must be configured with `useJUnitPlatform()` to run JUnit Jupiter tests. This recipe adds the `useJUnitPlatform()` method call to the `Test` task configuration.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new IsBuildGradle(), (TreeVisitor)new GroovyIsoVisitor<ExecutionContext>(){

            public G.CompilationUnit visitCompilationUnit(G.CompilationUnit compilationUnit, ExecutionContext ctx) {
                if (!GradleUseJunitJupiter.IsBuildGradle(compilationUnit) || !GradleUseJunitJupiter.hasJavaBasePlugin(compilationUnit).booleanValue() || GradleUseJunitJupiter.containsJUnitPlatformInvocation(compilationUnit)) {
                    return compilationUnit;
                }
                G.CompilationUnit cu = (G.CompilationUnit)new UpdateExistingUseJunit4().visitNonNull((Tree)compilationUnit, ctx, Objects.requireNonNull(this.getCursor().getParent()));
                if (cu != compilationUnit) {
                    return cu;
                }
                if ((cu = (G.CompilationUnit)new AddJUnitPlatformToExistingTestDsl().visitNonNull((Tree)cu, ctx, Objects.requireNonNull(this.getCursor().getParent()))) != compilationUnit) {
                    return cu;
                }
                return (G.CompilationUnit)new AddUseJUnitPlatform().visitNonNull((Tree)cu, ctx, this.getCursor().getParent());
            }
        });
    }

    private static boolean IsBuildGradle(G.CompilationUnit compilationUnit) {
        return compilationUnit.getSourcePath().toString().endsWith("build.gradle");
    }

    private static Boolean hasJavaBasePlugin(G.CompilationUnit compilationUnit) {
        return compilationUnit.getMarkers().findFirst(GradleProject.class).map(gp -> gp.getPlugins().stream().anyMatch(it -> it.getFullyQualifiedClassName().contains("org.gradle.api.plugins.JavaBasePlugin"))).orElse(false);
    }

    private static boolean containsJUnitPlatformInvocation(G.CompilationUnit cu) {
        AtomicBoolean found = new AtomicBoolean(false);
        new GroovyIsoVisitor<AtomicBoolean>(){

            public @Nullable J preVisit(J tree, AtomicBoolean found) {
                if (found.get()) {
                    this.stopAfterPreVisit();
                    return tree;
                }
                return (J)super.preVisit((Tree)tree, (Object)found);
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation m, AtomicBoolean found) {
                if ("useJUnitPlatform".equals(m.getSimpleName()) && (m.getArguments().isEmpty() || m.getArguments().size() == 1 && (m.getArguments().get(0) instanceof J.Empty || m.getArguments().get(0) instanceof J.Lambda))) {
                    found.set(true);
                    return m;
                }
                return super.visitMethodInvocation(m, (Object)found);
            }
        }.visit((Tree)cu, (Object)found);
        return found.get();
    }

    private static Optional<J.MethodInvocation> createTaskUseJUnitPlatform(ExecutionContext ctx, boolean forEachInvocation) {
        String groovySnippet = "plugins {\n    id 'java'\n}\ntasks.withType(Test)" + (forEachInvocation ? ".configureEach" : "") + " {\n    useJUnitPlatform()\n}";
        SourceFile sourceFile = GradleParser.builder().build().parse(ctx, new String[]{groovySnippet}).findFirst().orElse(null);
        if (sourceFile == null) {
            return Optional.empty();
        }
        if (sourceFile instanceof ParseError) {
            ParseError parseError = (ParseError)sourceFile;
            throw new IllegalStateException("Failed to parse Groovy snippet for useJUnitPlatform(). Snippet: [" + groovySnippet.replace("\n", "\\n") + "]", parseError.toException());
        }
        G.CompilationUnit cu = (G.CompilationUnit)sourceFile;
        return Optional.of((J.MethodInvocation)cu.getStatements().get(1));
    }

    @Generated
    public GradleUseJunitJupiter() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "GradleUseJunitJupiter()";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GradleUseJunitJupiter)) {
            return false;
        }
        GradleUseJunitJupiter other = (GradleUseJunitJupiter)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof GradleUseJunitJupiter;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class AddJUnitPlatformAsLastStatementInClosure
    extends GroovyIsoVisitor<ExecutionContext> {
        private AddJUnitPlatformAsLastStatementInClosure() {
        }

        public J.Lambda visitLambda(J.Lambda l, ExecutionContext ctx) {
            if (!(l.getBody() instanceof J.Block)) {
                return l;
            }
            return GradleUseJunitJupiter.createTaskUseJUnitPlatform(ctx, false).map(it -> (J.Lambda)it.getArguments().get(1)).map(it -> (J.Block)it.getBody()).map(it -> (J.Return)it.getStatements().get(0)).map(it -> (J.MethodInvocation)it.getExpression()).map(useJUnitPlatform -> {
                J.Block b = (J.Block)l.getBody();
                J.Lambda j = l.withBody((J)b.withStatements(ListUtils.concat((List)b.getStatements(), (Object)useJUnitPlatform)));
                return (J.Lambda)this.autoFormat((J)j, ctx, Objects.requireNonNull(this.getCursor().getParent()));
            }).orElse(l);
        }
    }

    private static class AddJUnitPlatformToExistingTestDsl
    extends GroovyIsoVisitor<ExecutionContext> {
        private AddJUnitPlatformToExistingTestDsl() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            String mName;
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            switch (mName = m.getSimpleName()) {
                case "test": {
                    if (m.getArguments().size() != 1 || !(m.getArguments().get(0) instanceof J.Lambda)) {
                        return m;
                    }
                    if (this.getCursor().getParentTreeCursor().firstEnclosing(J.MethodInvocation.class) == null) break;
                    return m;
                }
                case "named": {
                    if (m.getArguments().isEmpty()) {
                        return m;
                    }
                    if (!(m.getArguments().get(0) instanceof J.Literal) || !"test".equals(((J.Literal)m.getArguments().get(0)).getValue())) {
                        return m;
                    }
                    if (m.getArguments().get(m.getArguments().size() - 1) instanceof J.Lambda) break;
                    return m;
                }
                case "withType": {
                    if (m.getSelect() == null) {
                        return m;
                    }
                    if (!(TypeUtils.isOfClassType((JavaType)m.getSelect().getType(), (String)"org.gradle.api.tasks.TaskContainer") || m.getSelect() instanceof J.Identifier && "tasks".equals(((J.Identifier)m.getSelect()).getSimpleName()))) {
                        return m;
                    }
                    if (m.getArguments().get(0) instanceof J.Identifier && "Test".equals(((J.Identifier)m.getArguments().get(0)).getSimpleName())) break;
                    return m;
                }
                case "configureEach": {
                    if (m.getArguments().size() != 1 || !(m.getArguments().get(0) instanceof J.Lambda)) {
                        return m;
                    }
                    if (m.getSelect() == null || !(m.getSelect() instanceof J.MethodInvocation)) {
                        return m;
                    }
                    J.MethodInvocation select = (J.MethodInvocation)m.getSelect();
                    if ("withType".equals(select.getSimpleName()) && select.getArguments().size() == 1 && select.getArguments().get(0) instanceof J.Identifier && "Test".equals(((J.Identifier)select.getArguments().get(0)).getSimpleName())) break;
                    return m;
                }
                default: {
                    return m;
                }
            }
            return (J.MethodInvocation)new AddJUnitPlatformAsLastStatementInClosure().visitNonNull((Tree)m, ctx, Objects.requireNonNull(this.getCursor().getParent()));
        }
    }

    private static class AddUseJUnitPlatform
    extends GroovyIsoVisitor<ExecutionContext> {
        private AddUseJUnitPlatform() {
        }

        public G.CompilationUnit visitCompilationUnit(G.CompilationUnit cu, ExecutionContext ctx) {
            J.MethodInvocation task = GradleUseJunitJupiter.createTaskUseJUnitPlatform(ctx, true).orElse(null);
            return cu.withStatements(ListUtils.concat((List)cu.getStatements(), (Object)task));
        }
    }

    private static class UpdateExistingUseJunit4
    extends GroovyIsoVisitor<ExecutionContext> {
        private UpdateExistingUseJunit4() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
            if ("useJUnit".equals(m.getSimpleName()) && (m.getArguments().isEmpty() || m.getArguments().size() == 1 && m.getArguments().get(0) instanceof J.Empty)) {
                JavaType.Method useJUnitPlatformType = Optional.ofNullable(m.getMethodType()).map(JavaType.Method::getDeclaringType).flatMap(declaringType -> declaringType.getMethods().stream().filter(method1 -> "useJUnitPlatform".equals(method1.getName())).findFirst()).orElse(null);
                return m.withName(m.getName().withSimpleName("useJUnitPlatform")).withMethodType(useJUnitPlatformType);
            }
            return m;
        }
    }
}

