/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import com.google.errorprone.refaster.Refaster;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.openrewrite.java.template.RecipeDescriptor;

@RecipeDescriptor(name="Adopt AssertJ Double Assertions", description="Adopt AssertJ Double Assertions. Favor semantically explicit methods (e.g. `myDouble.isZero()` over `myDouble.isEqualTo(0.0)`).")
public class AssertJDoubleRules {

    @RecipeDescriptor(name="Replace `isEqualTo(1)` with `isOne()`", description="Replace `isEqualTo(1)` with `isOne()`.")
    static final class AbstractDoubleAssertIsOne {
        AbstractDoubleAssertIsOne() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isEqualTo(1.0);
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isOne();
        }
    }

    @RecipeDescriptor(name="Replace `isNotEqualTo(0)` with `isNotZero()`", description="Replace `isNotEqualTo(0)` with `isNotZero()`.")
    static final class AbstractDoubleAssertIsNotZero {
        AbstractDoubleAssertIsNotZero() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isNotEqualTo(0.0);
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isNotZero();
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo(0)` with `isZero()`", description="Replace `isEqualTo(0)` with `isZero()`.")
    static final class AbstractDoubleAssertIsZero {
        AbstractDoubleAssertIsZero() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isEqualTo(0.0);
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert) {
            return doubleAssert.isZero();
        }
    }

    @RecipeDescriptor(name="Replace `isNotCloseTo` with `isNotEqualTo`", description="Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractDoubleAssertIsNotEqualTo {
        AbstractDoubleAssertIsNotEqualTo() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n) {
            return (AbstractDoubleAssert)Refaster.anyOf((Object[])new AbstractDoubleAssert[]{doubleAssert.isNotCloseTo(n, Offset.offset((Number)0.0)), doubleAssert.isNotCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n) {
            return doubleAssert.isNotEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isCloseTo` with `isEqualTo`", description="Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.")
    static final class AbstractDoubleAssertIsEqualTo {
        AbstractDoubleAssertIsEqualTo() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n) {
            return (AbstractDoubleAssert)Refaster.anyOf((Object[])new AbstractDoubleAssert[]{doubleAssert.isCloseTo(n, Offset.offset((Number)0.0)), doubleAssert.isCloseTo(n, Percentage.withPercentage((double)0.0))});
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n) {
            return doubleAssert.isEqualTo(n);
        }
    }

    @RecipeDescriptor(name="Replace `isEqualTo` with `isCloseTo`", description="Replace `isEqualTo` with `isCloseTo` when `offset` or `percentage` is provided.")
    static final class AbstractDoubleAssertIsCloseToWithOffset {
        AbstractDoubleAssertIsCloseToWithOffset() {
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, double n, Offset<Double> offset) {
            return doubleAssert.isEqualTo(n, offset);
        }

        AbstractDoubleAssert<?> before(AbstractDoubleAssert<?> doubleAssert, Double n, Offset<Double> offset) {
            return doubleAssert.isEqualTo(n, offset);
        }

        AbstractDoubleAssert<?> after(AbstractDoubleAssert<?> doubleAssert, double n, Offset<Double> offset) {
            return doubleAssert.isCloseTo(n, offset);
        }
    }
}

