/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.assertj;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJFloatRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "Adopt AssertJ Float Assertions";
    }

    public String getDescription() {
        return "Adopt AssertJ Float Assertions. Favor semantically explicit methods (e.g. `myFloat.isZero()` over `myFloat.isEqualTo(0.0f)`).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractFloatAssertIsCloseToWithOffsetRecipe(), new AbstractFloatAssertIsEqualToRecipe(), new AbstractFloatAssertIsNotEqualToRecipe(), new AbstractFloatAssertIsZeroRecipe(), new AbstractFloatAssertIsNotZeroRecipe(), new AbstractFloatAssertIsOneRecipe()});
    }

    @NullMarked
    public static class AbstractFloatAssertIsCloseToWithOffsetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo` with `isCloseTo`";
        }

        public String getDescription() {
            return "Replace `isEqualTo` with `isCloseTo` when `offset` or `percentage` is provided.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(#{n:any(float)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Float>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before0 = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(#{n:any(java.lang.Float)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Float>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isCloseTo(#{n:any(float)}, #{offset:any(org.assertj.core.data.Offset<java.lang.Float>)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before0.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1), matcher.parameter(2)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesType("org.assertj.core.data.Offset", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractFloatAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isCloseTo` with `isEqualTo`";
        }

        public String getDescription() {
            return "Replace `isCloseTo` with `isEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isCloseTo(#{n:any(float)}, org.assertj.core.data.Offset.offset(0.0F))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isCloseTo(#{n:any(float)}, org.assertj.core.data.Percentage.withPercentage(0))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(#{n:any(float)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractFloatAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotCloseTo` with `isNotEqualTo`";
        }

        public String getDescription() {
            return "Replace `isNotCloseTo` with `isNotEqualTo` when `offset` or `percentage` is zero.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotCloseTo(#{n:any(float)}, org.assertj.core.data.Offset.offset(0.0F))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotCloseTo(#{n:any(float)}, org.assertj.core.data.Percentage.withPercentage(0))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotEqualTo(#{n:any(float)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isNotCloseTo(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)", true), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractFloatAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(0)` with `isZero()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(0)` with `isZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isZero()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractFloatAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`";
        }

        public String getDescription() {
            return "Replace `isNotEqualTo(0)` with `isNotZero()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotEqualTo(0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isNotZero()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isNotEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AbstractFloatAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Replace `isEqualTo(1)` with `isOne()`";
        }

        public String getDescription() {
            return "Replace `isEqualTo(1)` with `isOne()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isEqualTo(1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{floatAssert:any(org.assertj.core.api.AbstractFloatAssert<?>)}.isOne()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractFloatAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractFloatAssert isEqualTo(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

