/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to AssertJ expressions and statements [Source](https://error-prone.picnic.tech/refasterrules/AssertJRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AssertThatOptionalDoubleRecipe(), new AssertThatOptionalIntRecipe(), new AssertThatOptionalLongRecipe()});
    }

    @NullMarked
    public static class AssertThatOptionalDoubleRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalDouble`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalDouble {\n    \n    @BeforeTemplate\n    AbstractDoubleAssert<?> before(OptionalDouble optional, double expected) {\n        return assertThat(optional.getAsDouble()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalDoubleAssert after(OptionalDouble optional, double expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}.getAsDouble()).isEqualTo(#{expected:any(double)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalDouble)}).hasValue(#{expected:any(double)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractDoubleAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalDouble", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractDoubleAssert", Boolean.valueOf(true)), new UsesMethod("java.util.OptionalDouble getAsDouble(..)", true), new UsesMethod("org.assertj.core.api.AbstractDoubleAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatOptionalIntRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalInt`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalInt {\n    \n    @BeforeTemplate\n    AbstractIntegerAssert<?> before(OptionalInt optional, int expected) {\n        return assertThat(optional.getAsInt()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalIntAssert after(OptionalInt optional, int expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}.getAsInt()).isEqualTo(#{expected:any(int)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalInt)}).hasValue(#{expected:any(int)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractIntegerAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalInt", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractIntegerAssert", Boolean.valueOf(true)), new UsesMethod("java.util.OptionalInt getAsInt(..)", true), new UsesMethod("org.assertj.core.api.AbstractIntegerAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class AssertThatOptionalLongRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJRules.AssertThatOptionalLong`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AssertThatOptionalLong {\n    \n    @BeforeTemplate\n    AbstractLongAssert<?> before(OptionalLong optional, long expected) {\n        return assertThat(optional.getAsLong()).isEqualTo(expected);\n    }\n    \n    @AfterTemplate\n    @UseImportPolicy(value = STATIC_IMPORT_ALWAYS)\n    OptionalLongAssert after(OptionalLong optional, long expected) {\n        return assertThat(optional).hasValue(expected);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}.getAsLong()).isEqualTo(#{expected:any(long)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"org.assertj.core.api.Assertions.assertThat(#{optional:any(java.util.OptionalLong)}).hasValue(#{expected:any(long)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.api.AbstractLongAssert");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.OptionalLong", Boolean.valueOf(true)), new UsesType("org.assertj.core.api.AbstractLongAssert", Boolean.valueOf(true)), new UsesMethod("java.util.OptionalLong getAsLong(..)", true), new UsesMethod("org.assertj.core.api.AbstractLongAssert isEqualTo(..)", true), new UsesMethod("org.assertj.core.api.Assertions assertThat(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

