/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class WebClientRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`WebClientRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `org.springframework.web.reactive.function.client.WebClient` and related types.\n[Source](https://error-prone.picnic.tech/refasterrules/WebClientRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new BodyValueRecipe(), new WebClientGetRecipe(), new WebClientHeadRecipe(), new WebClientOptionsRecipe(), new WebClientPatchRecipe(), new WebClientPostRecipe(), new WebClientPutRecipe()});
    }

    @NullMarked
    public static class BodyValueRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `WebClientRules.BodyValue`";
        }

        public String getDescription() {
            return "Prefer `RequestBodySpec#bodyValue(Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{requestBodySpec:any(org.springframework.web.reactive.function.client.WebClient.RequestBodySpec)}.body(org.springframework.web.reactive.function.BodyInserters.fromValue(#{value:any(T)}))").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.web.reactive.function.BodyInserters.fromValue");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{requestBodySpec:any(org.springframework.web.reactive.function.client.WebClient.RequestBodySpec)}.bodyValue(#{value:any(T)})").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{requestBodySpec:any(org.springframework.test.web.reactive.server.WebTestClient.RequestBodySpec)}.body(org.springframework.web.reactive.function.BodyInserters.fromValue(#{value:any(T)}))").bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.web.reactive.function.BodyInserters.fromValue");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{requestBodySpec:any(org.springframework.web.reactive.function.client.WebClient.RequestBodySpec)}.bodyValue(#{value:any(T)})").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").genericTypes(new String[]{"T"}).javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.springframework.web.reactive.function.BodyInserters fromValue(..)", true), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient.RequestBodySpec body(..)", true), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestBodySpec", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient.RequestBodySpec body(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WebClientGetRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `WebClientRules.WebClientGet`";
        }

        public String getDescription() {
            return "Prefer `WebClient#get()` over `WebClient#method(HttpMethod)` with `HttpMethod#GET`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.GET)").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.get()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.GET)").bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.GET");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.get()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WebClientHeadRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `WebClientRules.WebClientHead`";
        }

        public String getDescription() {
            return "Prefer `WebClient#head()` over `WebClient#method(HttpMethod)` with `HttpMethod#HEAD`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.HEAD)").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.head()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.HEAD)").bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.HEAD");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.head()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WebClientOptionsRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `WebClientRules.WebClientOptions`";
        }

        public String getDescription() {
            return "Prefer `WebClient#options()` over `WebClient#method(HttpMethod)` with `HttpMethod#OPTIONS`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.OPTIONS)").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.options()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.OPTIONS)").bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.OPTIONS");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.options()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec<?>").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestHeadersSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WebClientPatchRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `WebClientRules.WebClientPatch`";
        }

        public String getDescription() {
            return "Prefer `WebClient#patch()` over `WebClient#method(HttpMethod)` with `HttpMethod#PATCH`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.PATCH)").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.patch()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.PATCH)").bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PATCH");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.patch()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WebClientPostRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `WebClientRules.WebClientPost`";
        }

        public String getDescription() {
            return "Prefer `WebClient#post()` over `WebClient#method(HttpMethod)` with `HttpMethod#POST`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.POST)").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.post()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.POST)").bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.POST");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.post()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class WebClientPutRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `WebClientRules.WebClientPut`";
        }

        public String getDescription() {
            return "Prefer `WebClient#put()` over `WebClient#method(HttpMethod)` with `HttpMethod#PUT`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate before0;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.method(org.springframework.http.HttpMethod.PUT)").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.put()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before0 == null) {
                        this.before0 = JavaTemplate.builder((String)"#{webClient:any(org.springframework.test.web.reactive.server.WebTestClient)}.method(org.springframework.http.HttpMethod.PUT)").bindType("org.springframework.test.web.reactive.server.WebTestClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                    }
                    if ((matcher = this.before0.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("org.springframework.test.web.reactive.server.WebTestClient");
                        this.maybeRemoveImport("org.springframework.http.HttpMethod.PUT");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{webClient:any(org.springframework.web.reactive.function.client.WebClient)}.put()").bindType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.test.web.reactive.server.WebTestClient", Boolean.valueOf(true)), new UsesMethod("org.springframework.test.web.reactive.server.WebTestClient method(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.springframework.web.reactive.function.client.WebClient", Boolean.valueOf(true)), new UsesType("org.springframework.web.reactive.function.client.WebClient.RequestBodyUriSpec", Boolean.valueOf(true)), new UsesMethod("org.springframework.web.reactive.function.client.WebClient method(..)", true)})}), (TreeVisitor)javaVisitor);
        }
    }
}

