/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.weblogic.rewrite.jakarta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.maven.MavenDownloadingException;
import org.openrewrite.maven.MavenIsoVisitor;
import org.openrewrite.maven.table.MavenMetadataFailures;
import org.openrewrite.maven.tree.MavenMetadata;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public final class UpgradeMavenPluginArtifactItems
extends Recipe {
    private final transient MavenMetadataFailures metadataFailures = new MavenMetadataFailures((Recipe)this);
    @Option(displayName="Old group ID", description="The old group ID to replace.", example="javax")
    private final String oldGroupId;
    @Option(displayName="Old artifact ID", description="The old artifact ID to replace.", example="javax")
    private final String oldArtifactId;
    @Option(displayName="New group ID", description="The new group ID to use.", example="jakarta.platform")
    private final String newGroupId;
    @Option(displayName="New artifact ID", description="The new artifact ID to use.", example="javaee-api")
    private final String newArtifactId;
    @Option(displayName="New version", description="An exact version number.", example="9.1", required=false)
    private final @Nullable String newVersion;
    private static final XPathMatcher PLUGIN_ARTIFACT_ITEM_MATCHER = new XPathMatcher("/project/build/plugins/plugin/executions/execution/configuration/artifactItems/artifactItem");
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String ARTIFACT_VERSION = "version";

    public String getDescription() {
        return "Change the groupId and the artifactId of an artifactItem in the configuration section of a plugin's execution. This recipe does not perform any validation and assumes all values passed are valid.";
    }

    public String getDisplayName() {
        return "Upgrade group, artifact ID and version of an artifactItem, of a maven plugin execution configuration";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenIsoVisitor<ExecutionContext>(){
            final @Nullable VersionComparator versionComparator;
            private @Nullable Collection<String> availableVersions;
            {
                this.versionComparator = UpgradeMavenPluginArtifactItems.this.newVersion != null ? (VersionComparator)Semver.validate((String)UpgradeMavenPluginArtifactItems.this.newVersion, null).getValue() : null;
            }

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (PLUGIN_ARTIFACT_ITEM_MATCHER.matches(this.getCursor())) {
                    boolean isGroupIdFound = tag.getChildValue(UpgradeMavenPluginArtifactItems.GROUP_ID).map(a -> StringUtils.matchesGlob((String)a, (String)UpgradeMavenPluginArtifactItems.this.oldGroupId)).orElse(UpgradeMavenPluginArtifactItems.this.oldGroupId == null);
                    isGroupIdFound = this.isElementFound(tag, isGroupIdFound, UpgradeMavenPluginArtifactItems.GROUP_ID, UpgradeMavenPluginArtifactItems.this.oldGroupId);
                    boolean isArtifactIdFound = tag.getChildValue(UpgradeMavenPluginArtifactItems.ARTIFACT_ID).map(a -> StringUtils.matchesGlob((String)a, (String)UpgradeMavenPluginArtifactItems.this.oldArtifactId)).orElse(UpgradeMavenPluginArtifactItems.this.oldArtifactId == null);
                    isArtifactIdFound = this.isElementFound(tag, isArtifactIdFound, UpgradeMavenPluginArtifactItems.ARTIFACT_ID, UpgradeMavenPluginArtifactItems.this.oldArtifactId);
                    if (isGroupIdFound && isArtifactIdFound) {
                        if (UpgradeMavenPluginArtifactItems.this.newGroupId != null) {
                            t = this.changeChildTagValue(t, UpgradeMavenPluginArtifactItems.GROUP_ID, UpgradeMavenPluginArtifactItems.this.newGroupId, ctx);
                        }
                        if (UpgradeMavenPluginArtifactItems.this.newArtifactId != null) {
                            t = this.changeChildTagValue(t, UpgradeMavenPluginArtifactItems.ARTIFACT_ID, UpgradeMavenPluginArtifactItems.this.newArtifactId, ctx);
                        }
                        String currentVersion = t.getChildValue(UpgradeMavenPluginArtifactItems.ARTIFACT_VERSION).orElse(null);
                        if (UpgradeMavenPluginArtifactItems.this.newVersion != null) {
                            try {
                                String resolvedNewVersion = this.resolveSemverVersion(ctx, UpgradeMavenPluginArtifactItems.this.newGroupId, UpgradeMavenPluginArtifactItems.this.newArtifactId, currentVersion);
                                Optional versionTag = t.getChild(UpgradeMavenPluginArtifactItems.ARTIFACT_VERSION);
                                boolean versionTagPresent = versionTag.isPresent();
                                if (versionTagPresent) {
                                    t = this.changeChildTagValue(t, UpgradeMavenPluginArtifactItems.ARTIFACT_VERSION, resolvedNewVersion, ctx);
                                }
                            }
                            catch (MavenDownloadingException e) {
                                return (Xml.Tag)e.warn((Tree)tag);
                            }
                        }
                    }
                }
                return t;
            }

            private boolean isElementFound(Xml.Tag tag, boolean isElementFound, String groupId, String oldGroupId) {
                if (!isElementFound && tag.getChildValue(groupId).isPresent() && ((String)tag.getChildValue(groupId).get()).trim().startsWith("${")) {
                    String propertyKey = ((String)tag.getChildValue(groupId).get()).trim();
                    String value = this.getResolutionResult().getPom().getValue(propertyKey);
                    isElementFound = value != null && StringUtils.matchesGlob((String)value, (String)oldGroupId);
                }
                return isElementFound;
            }

            private String resolveSemverVersion(ExecutionContext ctx, String groupId, String artifactId, @Nullable String currentVersion) throws MavenDownloadingException {
                String finalCurrentVersion;
                if (this.versionComparator == null) {
                    return UpgradeMavenPluginArtifactItems.this.newVersion;
                }
                String string = finalCurrentVersion = currentVersion != null ? currentVersion : UpgradeMavenPluginArtifactItems.this.newVersion;
                if (this.availableVersions == null) {
                    this.availableVersions = new ArrayList<String>();
                    MavenMetadata mavenMetadata = UpgradeMavenPluginArtifactItems.this.metadataFailures.insertRows(ctx, () -> this.downloadMetadata(groupId, artifactId, ctx));
                    for (String v : mavenMetadata.getVersioning().getVersions()) {
                        if (!this.versionComparator.isValid(finalCurrentVersion, v)) continue;
                        this.availableVersions.add(v);
                    }
                }
                return this.availableVersions.isEmpty() ? UpgradeMavenPluginArtifactItems.this.newVersion : Collections.max(this.availableVersions, this.versionComparator);
            }
        };
    }

    @Generated
    public UpgradeMavenPluginArtifactItems(String oldGroupId, String oldArtifactId, String newGroupId, String newArtifactId, @Nullable String newVersion) {
        this.oldGroupId = oldGroupId;
        this.oldArtifactId = oldArtifactId;
        this.newGroupId = newGroupId;
        this.newArtifactId = newArtifactId;
        this.newVersion = newVersion;
    }

    @Generated
    public MavenMetadataFailures getMetadataFailures() {
        return this.metadataFailures;
    }

    @Generated
    public String getOldGroupId() {
        return this.oldGroupId;
    }

    @Generated
    public String getOldArtifactId() {
        return this.oldArtifactId;
    }

    @Generated
    public String getNewGroupId() {
        return this.newGroupId;
    }

    @Generated
    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Generated
    public @Nullable String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public String toString() {
        return "UpgradeMavenPluginArtifactItems(metadataFailures=" + String.valueOf(this.getMetadataFailures()) + ", oldGroupId=" + this.getOldGroupId() + ", oldArtifactId=" + this.getOldArtifactId() + ", newGroupId=" + this.getNewGroupId() + ", newArtifactId=" + this.getNewArtifactId() + ", newVersion=" + this.getNewVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradeMavenPluginArtifactItems)) {
            return false;
        }
        UpgradeMavenPluginArtifactItems other = (UpgradeMavenPluginArtifactItems)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldGroupId = this.getOldGroupId();
        String other$oldGroupId = other.getOldGroupId();
        if (this$oldGroupId == null ? other$oldGroupId != null : !this$oldGroupId.equals(other$oldGroupId)) {
            return false;
        }
        String this$oldArtifactId = this.getOldArtifactId();
        String other$oldArtifactId = other.getOldArtifactId();
        if (this$oldArtifactId == null ? other$oldArtifactId != null : !this$oldArtifactId.equals(other$oldArtifactId)) {
            return false;
        }
        String this$newGroupId = this.getNewGroupId();
        String other$newGroupId = other.getNewGroupId();
        if (this$newGroupId == null ? other$newGroupId != null : !this$newGroupId.equals(other$newGroupId)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        return !(this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UpgradeMavenPluginArtifactItems;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldGroupId = this.getOldGroupId();
        result = result * 59 + ($oldGroupId == null ? 43 : $oldGroupId.hashCode());
        String $oldArtifactId = this.getOldArtifactId();
        result = result * 59 + ($oldArtifactId == null ? 43 : $oldArtifactId.hashCode());
        String $newGroupId = this.getNewGroupId();
        result = result * 59 + ($newGroupId == null ? 43 : $newGroupId.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        return result;
    }
}

