/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.customRecipes;

import java.util.ArrayList;
import java.util.Optional;
import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelXmlVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.tree.Xml;

public class ReplacePropertyInComponentXml
extends Recipe {
    private static final XPathMatcher FROM_MATCHER = new XPathMatcher("//route/from");
    private static final XPathMatcher TO_MATCHER = new XPathMatcher("//route/to");
    @Option(example="TODO Provide a usage example for the docs", displayName="Component", description="Component name.")
    String component;
    @Option(example="TODO Provide a usage example for the docs", displayName="Old property key", description="The property key to rename.")
    String oldPropertyKey;
    @Option(example="TODO Provide a usage example for the docs", displayName="New prefix before any group", description="The prefix to be replaced with.")
    String newPropertyKey;
    @Option(example="file:", displayName="New prefix before value of the changed property", description="This value is appended before the current value of the modified method.", required=false)
    String valuePrefix;

    public String getDisplayName() {
        return "Camel XMl DSL changes";
    }

    public String getDescription() {
        return "Apache Camel XML DSL migration from version 4.9 o 4.10.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelXmlVisitor(){

            @Override
            public Xml.Tag doVisitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.doVisitTag(tag, ctx);
                if (FROM_MATCHER.matches(this.getCursor())) {
                    return ReplacePropertyInComponentXml.this.replacePropertyIfPossible(t);
                }
                if (TO_MATCHER.matches(this.getCursor())) {
                    return ReplacePropertyInComponentXml.this.replacePropertyIfPossible(t);
                }
                return t;
            }
        };
    }

    private Xml.Tag replacePropertyIfPossible(Xml.Tag tag) {
        ArrayList<Xml.Attribute> attributes = new ArrayList<Xml.Attribute>(tag.getAttributes());
        Optional<Xml.Attribute> uri = attributes.stream().filter(a -> "uri".equals(a.getKey().getName())).findAny();
        if (uri.isPresent() && (this.component.equals(uri.get().getValue().getValue()) || uri.get().getValue().getValue().startsWith(this.component + ":"))) {
            String u = uri.get().getValue().getValue();
            if ((u = RecipesUtil.replacePropertyInUrl(u, this.component, this.oldPropertyKey, this.newPropertyKey, this.valuePrefix)) != null) {
                attributes.remove(uri.get());
                attributes.add(uri.get().withValue(uri.get().getValue().withValue(u)));
                return tag.withAttributes(attributes);
            }
        }
        return tag;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplacePropertyInComponentXml)) {
            return false;
        }
        ReplacePropertyInComponentXml other = (ReplacePropertyInComponentXml)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$component = this.component;
        String other$component = other.component;
        if (this$component == null ? other$component != null : !this$component.equals(other$component)) {
            return false;
        }
        String this$oldPropertyKey = this.oldPropertyKey;
        String other$oldPropertyKey = other.oldPropertyKey;
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPropertyKey = this.newPropertyKey;
        String other$newPropertyKey = other.newPropertyKey;
        if (this$newPropertyKey == null ? other$newPropertyKey != null : !this$newPropertyKey.equals(other$newPropertyKey)) {
            return false;
        }
        String this$valuePrefix = this.valuePrefix;
        String other$valuePrefix = other.valuePrefix;
        return !(this$valuePrefix == null ? other$valuePrefix != null : !this$valuePrefix.equals(other$valuePrefix));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReplacePropertyInComponentXml;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $component = this.component;
        result = result * 59 + ($component == null ? 43 : $component.hashCode());
        String $oldPropertyKey = this.oldPropertyKey;
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPropertyKey = this.newPropertyKey;
        result = result * 59 + ($newPropertyKey == null ? 43 : $newPropertyKey.hashCode());
        String $valuePrefix = this.valuePrefix;
        result = result * 59 + ($valuePrefix == null ? 43 : $valuePrefix.hashCode());
        return result;
    }

    @Generated
    public ReplacePropertyInComponentXml() {
    }

    @Generated
    public ReplacePropertyInComponentXml(String component, String oldPropertyKey, String newPropertyKey, String valuePrefix) {
        this.component = component;
        this.oldPropertyKey = oldPropertyKey;
        this.newPropertyKey = newPropertyKey;
        this.valuePrefix = valuePrefix;
    }

    @Generated
    public void setComponent(String component) {
        this.component = component;
    }

    @Generated
    public void setOldPropertyKey(String oldPropertyKey) {
        this.oldPropertyKey = oldPropertyKey;
    }

    @Generated
    public void setNewPropertyKey(String newPropertyKey) {
        this.newPropertyKey = newPropertyKey;
    }

    @Generated
    public void setValuePrefix(String valuePrefix) {
        this.valuePrefix = valuePrefix;
    }
}

