/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.updates.core.quarkus310;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddToTagVisitor;
import org.openrewrite.xml.RemoveContentVisitor;
import org.openrewrite.xml.tree.Content;
import org.openrewrite.xml.tree.Xml;

public final class AdjustPackageProperty
extends Recipe {
    private static final String PROPERTIES = "properties";
    private static final String QUARKUS_PACKAGE_TYPE = "quarkus.package.type";
    private static final String QUARKUS_PACKAGE_JAR_TYPE = "quarkus.package.jar.type";
    private static final String QUARKUS_PACKAGE_JAR_ENABLED = "quarkus.package.jar.enabled";
    private static final String QUARKUS_NATIVE_ENABLED = "quarkus.native.enabled";
    private static final String QUARKUS_NATIVE_SOURCES_ONLY = "quarkus.native.sources-only";
    private static final String JAR = "jar";
    private static final String UBER_JAR = "uber-jar";
    private static final String FAST_JAR = "fast-jar";
    private static final String MUTABLE_JAR = "mutable-jar";
    private static final String NATIVE = "native";
    private static final String NATIVE_SOURCES = "native-sources";
    private static final Map<String, String> CONFIG_MAPPING = new HashMap<String, String>();

    public String getDisplayName() {
        return "Adjust the package properties";
    }

    public String getDescription() {
        return "Adjust the package properties";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Optional packageTypeValue;
                Optional packageType;
                Xml.Tag propertiesTag = (Xml.Tag)super.visitTag(tag, (Object)ctx);
                if (AdjustPackageProperty.PROPERTIES.equals(propertiesTag.getName()) && (packageType = propertiesTag.getChild(AdjustPackageProperty.QUARKUS_PACKAGE_TYPE)).isPresent() && (packageTypeValue = ((Xml.Tag)packageType.get()).getValue()).isPresent()) {
                    switch ((String)packageTypeValue.get()) {
                        case "jar": 
                        case "uber-jar": 
                        case "fast-jar": 
                        case "mutable-jar": {
                            propertiesTag = AddToTagVisitor.addToTag((Xml.Tag)propertiesTag, (Xml.Tag)Xml.Tag.build((String)("<quarkus.package.jar.type>" + (String)packageTypeValue.get() + "</quarkus.package.jar.type>")), (Cursor)this.getCursor().getParentOrThrow());
                            this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)packageType.get(), false));
                            break;
                        }
                        case "native": {
                            propertiesTag = AddToTagVisitor.addToTag((Xml.Tag)propertiesTag, (Xml.Tag)Xml.Tag.build((String)"<quarkus.native.enabled>true</quarkus.native.enabled>"), (Cursor)this.getCursor().getParentOrThrow());
                            propertiesTag = AddToTagVisitor.addToTag((Xml.Tag)propertiesTag, (Xml.Tag)Xml.Tag.build((String)"<quarkus.package.jar.enabled>false</quarkus.package.jar.enabled>"), (Cursor)this.getCursor().getParentOrThrow());
                            this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)packageType.get(), false));
                            break;
                        }
                        case "native-sources": {
                            propertiesTag = AddToTagVisitor.addToTag((Xml.Tag)propertiesTag, (Xml.Tag)Xml.Tag.build((String)"<quarkus.native.enabled>true</quarkus.native.enabled>"), (Cursor)this.getCursor().getParentOrThrow());
                            propertiesTag = AddToTagVisitor.addToTag((Xml.Tag)propertiesTag, (Xml.Tag)Xml.Tag.build((String)"<quarkus.native.sources-only>true</quarkus.native.sources-only>"), (Cursor)this.getCursor().getParentOrThrow());
                            propertiesTag = AddToTagVisitor.addToTag((Xml.Tag)propertiesTag, (Xml.Tag)Xml.Tag.build((String)"<quarkus.package.jar.enabled>false</quarkus.package.jar.enabled>"), (Cursor)this.getCursor().getParentOrThrow());
                            this.doAfterVisit((TreeVisitor)new RemoveContentVisitor((Content)packageType.get(), false));
                            break;
                        }
                    }
                }
                if (CONFIG_MAPPING.containsKey(propertiesTag.getName())) {
                    propertiesTag = propertiesTag.withName(CONFIG_MAPPING.get(propertiesTag.getName()));
                }
                return propertiesTag;
            }
        };
    }

    @Generated
    public AdjustPackageProperty() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "AdjustPackageProperty()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdjustPackageProperty)) {
            return false;
        }
        AdjustPackageProperty other = (AdjustPackageProperty)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AdjustPackageProperty;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    static {
        CONFIG_MAPPING.put("quarkus.package.create-appcds", "quarkus.package.jar.appcds.enabled");
        CONFIG_MAPPING.put("quarkus.package.appcds-builder-image", "quarkus.package.jar.appcds.builder-image");
        CONFIG_MAPPING.put("quarkus.package.appcds-use-container", "quarkus.package.jar.appcds.use-container");
        CONFIG_MAPPING.put("quarkus.package.compress-jar", "quarkus.package.jar.compress");
        CONFIG_MAPPING.put("quarkus.package.filter-optional-dependencies", "quarkus.package.jar.filter-optional-dependencies");
        CONFIG_MAPPING.put("quarkus.package.add-runner-suffix", "quarkus.package.jar.add-runner-suffix");
        CONFIG_MAPPING.put("quarkus.package.user-configured-ignored-entries", "quarkus.package.jar.user-configured-ignored-entries");
        CONFIG_MAPPING.put("quarkus.package.user-providers-directory", "quarkus.package.jar.user-providers-directory");
        CONFIG_MAPPING.put("quarkus.package.included-optional-dependencies", "quarkus.package.jar.included-optional-dependencies");
        CONFIG_MAPPING.put("quarkus.package.decompiler.enabled", "quarkus.package.jar.decompiler.enabled");
        CONFIG_MAPPING.put("quarkus.package.vineflower.enabled", "quarkus.package.jar.decompiler.enabled");
        CONFIG_MAPPING.put("quarkus.package.decompiler.jar-directory", "quarkus.package.jar.decompiler.jar-directory");
        CONFIG_MAPPING.put("quarkus.package.vineflower.jar-directory", "quarkus.package.jar.decompiler.jar-directory");
        CONFIG_MAPPING.put("quarkus.package.manifest.add-implementation-entries", "quarkus.package.jar.manifest.add-implementation-entries");
    }
}

