/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.updates;

import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCamelYamlVisitor
extends YamlIsoVisitor<ExecutionContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCamelYamlVisitor.class);

    protected abstract void clearLocalCache();

    public final Yaml.Document visitDocument(Yaml.Document document, ExecutionContext o) {
        this.clearLocalCache();
        Yaml.Document d = super.visitDocument(document, (Object)o);
        return d;
    }

    public final Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
        return this.executeVisitWithCatch(() -> this.doVisitMappingEntry(entry, executionContext), entry, executionContext);
    }

    public final Yaml.Sequence visitSequence(Yaml.Sequence sequence, ExecutionContext executionContext) {
        return this.executeVisitWithCatch(() -> this.doVisitSequence(sequence, executionContext), sequence, executionContext);
    }

    public final Yaml.Mapping visitMapping(Yaml.Mapping mapping, ExecutionContext executionContext) {
        return this.executeVisitWithCatch(() -> this.doVisitMapping(mapping, executionContext), mapping, executionContext);
    }

    public Yaml.Mapping.Entry doVisitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext executionContext) {
        return super.visitMappingEntry(entry, (Object)executionContext);
    }

    public Yaml.Sequence doVisitSequence(Yaml.Sequence sequence, ExecutionContext executionContext) {
        return super.visitSequence(sequence, (Object)executionContext);
    }

    public Yaml.Mapping doVisitMapping(Yaml.Mapping mapping, ExecutionContext executionContext) {
        return super.visitMapping(mapping, (Object)executionContext);
    }

    protected <T extends Yaml> T executeVisitWithCatch(Supplier<T> visitMethod, T origValue, ExecutionContext context) {
        try {
            return (T)((Yaml)visitMethod.get());
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Internal error detected in %s, recipe is skipped.", ((Object)((Object)this)).getClass().getName()), (Throwable)e);
            return origValue;
        }
    }
}

