/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.updates.camel40.yaml;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.camel.updates.AbstractCamelYamlVisitor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.format.IndentsVisitor;
import org.openrewrite.yaml.style.IndentsStyle;
import org.openrewrite.yaml.tree.Yaml;

public final class CamelYamlRouteConfigurationSequenceRecipe
extends Recipe {
    private static JsonPathMatcher MATCHER_ROUTE_CONFIGURATION = new JsonPathMatcher("$.route-configuration");
    private static JsonPathMatcher MATCHER_ROUTE_CONFIGURATION_ON_EXCEPTION = new JsonPathMatcher("$.route-configuration.on-exception");

    public String getDisplayName() {
        return "Camel Yaml changes regarding route-configuration children";
    }

    public String getDescription() {
        return "Camel YAML changes. route-configuration children sequence is replaced with  mappingEntry (with special migration of \"on-exception\").";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new AbstractCamelYamlVisitor(){
            private Yaml.Sequence sequenceToReplace;
            private boolean indentRegistered = false;

            @Override
            protected void clearLocalCache() {
                this.sequenceToReplace = null;
            }

            @Override
            public Yaml.Sequence doVisitSequence(Yaml.Sequence sequence, ExecutionContext context) {
                Yaml.Sequence s = super.doVisitSequence(sequence, context);
                if (new JsonPathMatcher("$.route-configuration").matches(this.getCursor().getParent())) {
                    this.sequenceToReplace = s;
                }
                return s;
            }

            @Override
            public Yaml.Mapping.Entry doVisitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext context) {
                Yaml.Mapping.Entry e = super.doVisitMappingEntry(entry, context);
                if (e.getValue() == this.sequenceToReplace) {
                    ArrayList entries = new ArrayList();
                    for (Yaml.Sequence.Entry sEntry : this.sequenceToReplace.getEntries()) {
                        if (!(sEntry.getBlock() instanceof Yaml.Mapping)) continue;
                        ((Yaml.Mapping)sEntry.getBlock()).getEntries().forEach(y -> {
                            if ("on-exception".equals(y.getKey().getValue())) {
                                Yaml.Sequence newSequence = this.sequenceToReplace.copyPaste();
                                List filteredEntries = newSequence.getEntries().stream().filter(se -> ((Yaml.Mapping)se.getBlock()).getEntries().stream().filter(me -> "on-exception".equals(me.getKey().getValue())).findFirst().isPresent()).collect(Collectors.toList());
                                entries.add(y.withValue((Yaml.Block)newSequence.withEntries(filteredEntries)).withPrefix("\n"));
                            } else {
                                entries.add(y.withPrefix("\n"));
                            }
                        });
                    }
                    Yaml.Mapping.Entry resultr = e.withValue((Yaml.Block)new Yaml.Mapping(Tree.randomId(), this.sequenceToReplace.getMarkers(), this.sequenceToReplace.getOpeningBracketPrefix(), entries, null, null));
                    if (!this.indentRegistered) {
                        this.indentRegistered = true;
                        this.doAfterVisit((TreeVisitor)new IndentsVisitor(new IndentsStyle(2), null));
                    }
                    return resultr;
                }
                return e;
            }
        };
    }

    @Generated
    public CamelYamlRouteConfigurationSequenceRecipe() {
    }

    @NonNull
    @Generated
    public String toString() {
        return "CamelYamlRouteConfigurationSequenceRecipe()";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CamelYamlRouteConfigurationSequenceRecipe)) {
            return false;
        }
        CamelYamlRouteConfigurationSequenceRecipe other = (CamelYamlRouteConfigurationSequenceRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof CamelYamlRouteConfigurationSequenceRecipe;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

