/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.updates.camel40.java;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.camel.updates.AbstractCamelJavaVisitor;
import org.apache.camel.updates.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.ChangeLiteral;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class CamelBeanRecipe
extends Recipe {
    private final String[] primitive = new String[]{"byte", "short", "int", "float", "double", "long", "char", "String"};

    public String getDisplayName() {
        return "Camel bean recipe";
    }

    public String getDescription() {
        return "Camel bean recipe.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelJavaVisitor(){

            @Override
            protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation mi = super.doVisitMethodInvocation(method, context);
                Pattern findMethodPattern = Pattern.compile("method=.*");
                if (mi.getSimpleName().equals("to")) {
                    List arguments = method.getArguments();
                    for (int i = 0; i < arguments.size(); ++i) {
                        Expression argument = (Expression)arguments.get(i);
                        if (!(argument instanceof J.Literal) || !((J.Literal)argument).getType().getClassName().equals("java.lang.String") || !findMethodPattern.matcher((String)((J.Literal)method.getArguments().get(i)).getValue()).find()) continue;
                        String uriWithMethod = (String)((J.Literal)method.getArguments().get(i)).getValue();
                        String uriWithoutMethod = uriWithMethod.split("=")[0];
                        String methodNameAndArgs = uriWithMethod.split("=")[1];
                        if (!methodNameAndArgs.contains("(") && !methodNameAndArgs.contains(")")) {
                            return mi;
                        }
                        String methodName = CamelBeanRecipe.this.extractMethodName(methodNameAndArgs);
                        String actualArgs = methodNameAndArgs.substring(methodNameAndArgs.indexOf("(") + 1, methodNameAndArgs.indexOf(")"));
                        String updatedArg = uriWithoutMethod + "=" + methodName + "(" + CamelBeanRecipe.this.updateMethodArgument(actualArgs) + ")";
                        this.doAfterVisit((TreeVisitor)new ChangeLiteral(argument, p -> updatedArg));
                        return mi;
                    }
                }
                return mi;
            }
        });
    }

    private String extractMethodName(String methodCallString) {
        Pattern pattern = Pattern.compile("^([a-zA-Z_$][a-zA-Z0-9_$]*)\\(.+\\)$");
        Matcher matcher = pattern.matcher(methodCallString);
        if (matcher.matches()) {
            String methodName = matcher.group(1);
            return methodName;
        }
        return null;
    }

    private String updateMethodArgument(String argument) {
        Pattern identifierPattern = Pattern.compile("^[a-zA-Z_$][a-zA-Z0-9_$]*$");
        Pattern fullyQualifiedPattern = Pattern.compile("^([a-zA-Z_$][a-zA-Z0-9_$]*\\.)*[a-zA-Z_$][a-zA-Z0-9_$]*$");
        String updatedArgs = Arrays.asList(argument.split(",")).stream().map(arg -> {
            String[] parts;
            if (arg.endsWith(".class")) {
                return arg;
            }
            if (Arrays.asList(this.primitive).contains(arg.trim())) {
                return arg + ".class";
            }
            Matcher fullyQualifiedMatcher = fullyQualifiedPattern.matcher((CharSequence)arg);
            if (!fullyQualifiedMatcher.matches()) {
                return arg;
            }
            for (String part : parts = arg.split("\\.")) {
                Matcher identifierMatcher = identifierPattern.matcher(part);
                if (identifierMatcher.matches()) continue;
                return arg;
            }
            return arg + ".class";
        }).collect(Collectors.joining(","));
        return updatedArgs;
    }
}

