/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.updates.camel43;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.xml.XPathMatcher;
import org.openrewrite.xml.XmlIsoVisitor;
import org.openrewrite.xml.tree.Xml;

public class CamelResequenceEIPXmlRecipe
extends Recipe {
    private static final XPathMatcher XML_RESEQUENCE_STREAM_CONFIG_MATCHER = new XPathMatcher("*/route/resequence/stream-config");
    private static final XPathMatcher XML_RESEQUENCE_BATCH_CONFIG_MATCHER = new XPathMatcher("*/route/resequence/batch-config");

    public String getDisplayName() {
        return "Camel Resequence DSL changes";
    }

    public String getDescription() {
        return "Batch and stream attributes were renamed in Resequence EIP XML DSL.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new XmlIsoVisitor<ExecutionContext>(){

            public Xml.Tag visitTag(Xml.Tag tag, ExecutionContext ctx) {
                Xml.Tag t = super.visitTag(tag, (Object)ctx);
                if (XML_RESEQUENCE_STREAM_CONFIG_MATCHER.matches(this.getCursor())) {
                    t = t.withName("streamConfig");
                } else if (XML_RESEQUENCE_BATCH_CONFIG_MATCHER.matches(this.getCursor())) {
                    t = t.withName("batchConfig");
                }
                return t;
            }
        };
    }
}

