/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.updates.customRecipes;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.properties.PropertiesVisitor;
import org.openrewrite.properties.tree.Properties;

public class ChangePropertyKeyWithCaseChange
extends Recipe {
    @Option(displayName="Old property key", description="The property key to rename.")
    String oldPropertyKey;
    @Option(displayName="New prefix before any group", description="The prefix to be replaced with.")
    String newPrefix;

    public String getDisplayName() {
        return "Change prefix of property with Camel case";
    }

    public String getDescription() {
        return "Change prefix of property with Camel case";
    }

    public PropertiesVisitor<ExecutionContext> getVisitor() {
        return new PropertiesVisitor<ExecutionContext>(){

            public Properties visitEntry(Properties.Entry entry, ExecutionContext p) {
                if (entry.getKey().matches(ChangePropertyKeyWithCaseChange.this.oldPropertyKey)) {
                    entry = entry.withKey(this.getKey(entry)).withPrefix(entry.getPrefix());
                }
                return super.visitEntry(entry, (Object)p);
            }

            private String getKey(Properties.Entry entry) {
                return ChangePropertyKeyWithCaseChange.this.newPrefix + entry.getKey().replaceFirst(ChangePropertyKeyWithCaseChange.this.oldPropertyKey, "$1").substring(0, 1).toLowerCase() + entry.getKey().replaceFirst(ChangePropertyKeyWithCaseChange.this.oldPropertyKey, "$1").substring(1);
            }
        };
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangePropertyKeyWithCaseChange)) {
            return false;
        }
        ChangePropertyKeyWithCaseChange other = (ChangePropertyKeyWithCaseChange)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldPropertyKey = this.oldPropertyKey;
        String other$oldPropertyKey = other.oldPropertyKey;
        if (this$oldPropertyKey == null ? other$oldPropertyKey != null : !this$oldPropertyKey.equals(other$oldPropertyKey)) {
            return false;
        }
        String this$newPrefix = this.newPrefix;
        String other$newPrefix = other.newPrefix;
        return !(this$newPrefix == null ? other$newPrefix != null : !this$newPrefix.equals(other$newPrefix));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangePropertyKeyWithCaseChange;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldPropertyKey = this.oldPropertyKey;
        result = result * 59 + ($oldPropertyKey == null ? 43 : $oldPropertyKey.hashCode());
        String $newPrefix = this.newPrefix;
        result = result * 59 + ($newPrefix == null ? 43 : $newPrefix.hashCode());
        return result;
    }

    @Generated
    public ChangePropertyKeyWithCaseChange() {
    }

    @Generated
    public ChangePropertyKeyWithCaseChange(String oldPropertyKey, String newPrefix) {
        this.oldPropertyKey = oldPropertyKey;
        this.newPrefix = newPrefix;
    }

    @Generated
    public void setOldPropertyKey(String oldPropertyKey) {
        this.oldPropertyKey = oldPropertyKey;
    }

    @Generated
    public void setNewPrefix(String newPrefix) {
        this.newPrefix = newPrefix;
    }
}

