/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNullApi;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class AssertJShortRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`AssertJShortRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster template recipes for `tech.picnic.errorprone.refasterrules.AssertJShortRules`. [Source](https://error-prone.picnic.tech/refasterrules/AssertJShortRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new AbstractShortAssertIsEqualToRecipe(), new AbstractShortAssertIsNotEqualToRecipe(), new AbstractShortAssertIsZeroRecipe(), new AbstractShortAssertIsNotZeroRecipe(), new AbstractShortAssertIsOneRecipe()});
    }

    @NonNullApi
    public static class AbstractShortAssertIsEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsEqualTo {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {\n        return Refaster.anyOf(shortAssert.isCloseTo(n, offset((short)0)), shortAssert.isCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {\n        return shortAssert.isEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isCloseTo(#{n:any(short)}, org.assertj.core.data.Offset.offset((short)0))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isCloseTo(#{n:any(short)}, org.assertj.core.data.Percentage.withPercentage(0))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo(#{n:any(short)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isCloseTo(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)"), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractShortAssertIsNotEqualToRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsNotEqualTo`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsNotEqualTo {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert, short n) {\n        return Refaster.anyOf(shortAssert.isNotCloseTo(n, offset((short)0)), shortAssert.isNotCloseTo(n, withPercentage(0)));\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert, short n) {\n        return shortAssert.isNotEqualTo(n);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before$0 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotCloseTo(#{n:any(short)}, org.assertj.core.data.Offset.offset((short)0))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate before$1 = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotCloseTo(#{n:any(short)}, org.assertj.core.data.Percentage.withPercentage(0))").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotEqualTo(#{n:any(short)})").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before$0.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Offset.offset");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    matcher = this.before$1.matcher(this.getCursor());
                    if (matcher.find()) {
                        this.maybeRemoveImport("org.assertj.core.data.Percentage.withPercentage");
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0), matcher.parameter(1)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isNotCloseTo(..)"), Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod("org.assertj.core.data.Offset offset(..)"), new UsesMethod("org.assertj.core.data.Percentage withPercentage(..)")})}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractShortAssertIsZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsZero {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isZero();\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isEqualTo((short)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isZero()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo((short)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractShortAssertIsNotZeroRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsNotZero`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsNotZero {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isNotZero();\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isNotEqualTo((short)0);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotZero()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isNotEqualTo((short)0)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isNotZero(..)")}), (TreeVisitor)javaVisitor);
        }
    }

    @NonNullApi
    public static class AbstractShortAssertIsOneRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `AssertJShortRules.AbstractShortAssertIsOne`";
        }

        public String getDescription() {
            return "Recipe created for the following Refaster template:\n```java\nstatic final class AbstractShortAssertIsOne {\n    \n    @BeforeTemplate\n    AbstractShortAssert<?> before(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isOne();\n    }\n    \n    @AfterTemplate\n    AbstractShortAssert<?> after(AbstractShortAssert<?> shortAssert) {\n        return shortAssert.isEqualTo((short)1);\n    }\n}\n```\n.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                final JavaTemplate before = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isOne()").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();
                final JavaTemplate after = JavaTemplate.builder((String)"#{shortAssert:any(org.assertj.core.api.AbstractShortAssert<?>)}.isEqualTo((short)1)").javaParser(JavaParser.fromJavaVersion().classpath((Collection)JavaParser.runtimeClasspath())).build();

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher = this.before.matcher(this.getCursor());
                    if (matcher.find()) {
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.assertj.core.api.AbstractShortAssert", Boolean.valueOf(true)), new UsesMethod("org.assertj.core.api.AbstractShortAssert isOne(..)")}), (TreeVisitor)javaVisitor);
        }
    }
}

