/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolParser;
import org.openrewrite.cobol.CobolPreprocessorIsoVisitor;
import org.openrewrite.cobol.CobolPreprocessorParser;
import org.openrewrite.cobol.CopybookParser;
import org.openrewrite.cobol.internal.CobolPrinter;
import org.openrewrite.cobol.internal.IbmAnsi85;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.cobol.tree.Space;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.ThrowingConsumer;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

public class Assertions {
    private Assertions() {
    }

    static void customizeExecutionContext(ExecutionContext ctx) {
    }

    public static SourceSpecs preprocessor(@Nullable String before) {
        return Assertions.preprocessor(before, (SourceSpec<CobolPreprocessor.CompilationUnit> s) -> {});
    }

    public static SourceSpecs preprocessor(@Nullable String before, Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec) {
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.CompilationUnit.class, null, (Parser.Builder)CobolPreprocessorParser.builder().copybooks(Assertions.getCopybookSources()), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        Assertions.acceptPreprocessorSpec(spec, (SourceSpec<CobolPreprocessor.CompilationUnit>)cobol);
        return cobol;
    }

    public static SourceSpecs preprocessor(@Nullable String before, @Nullable String after) {
        return Assertions.preprocessor(before, after, s -> {});
    }

    public static SourceSpecs preprocessor(@Nullable String before, @Nullable String after, Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec) {
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.CompilationUnit.class, null, (Parser.Builder)CobolPreprocessorParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext).after(s -> after);
        Assertions.acceptPreprocessorSpec(spec, (SourceSpec<CobolPreprocessor.CompilationUnit>)cobol);
        return cobol;
    }

    private static void acceptPreprocessorSpec(Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> spec, SourceSpec<CobolPreprocessor.CompilationUnit> cobol) {
        ThrowingConsumer userSuppliedAfterRecipe = cobol.getAfterRecipe();
        cobol.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        Assertions.isPreprocessorFullyParsed().andThen(spec).accept(cobol);
    }

    public static Consumer<SourceSpec<CobolPreprocessor.CompilationUnit>> isPreprocessorFullyParsed() {
        return spec -> spec.afterRecipe(cu -> new CobolPreprocessorIsoVisitor<Integer>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                String whitespace = space.getWhitespace().trim();
                if (!IbmAnsi85.getInstance().getSeparators().contains(whitespace + " ") && !whitespace.isEmpty()) {
                    return space.withWhitespace("(~~>" + whitespace + "<~~)");
                }
                return super.visitSpace(space, loc, integer);
            }
        }.visit((Tree)cu, 0));
    }

    public static SourceSpecs copybook(@Nullable String before) {
        return Assertions.copybook(before, (SourceSpec<CobolPreprocessor.Copybook> s) -> {});
    }

    public static SourceSpecs copybook(@Nullable String before, Consumer<SourceSpec<CobolPreprocessor.Copybook>> spec) {
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.Copybook.class, null, (Parser.Builder)CopybookParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        Assertions.acceptCopybookSpec(spec, (SourceSpec<CobolPreprocessor.Copybook>)cobol);
        return cobol;
    }

    public static SourceSpecs copybook(@Nullable String before, @Nullable String after) {
        return Assertions.copybook(before, after, s -> {});
    }

    public static SourceSpecs copybook(@Nullable String before, @Nullable String after, Consumer<SourceSpec<CobolPreprocessor.Copybook>> spec) {
        SourceSpec cobol = new SourceSpec(CobolPreprocessor.Copybook.class, null, (Parser.Builder)CopybookParser.builder(), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext).after(s -> after);
        Assertions.acceptCopybookSpec(spec, (SourceSpec<CobolPreprocessor.Copybook>)cobol);
        return cobol;
    }

    private static void acceptCopybookSpec(Consumer<SourceSpec<CobolPreprocessor.Copybook>> spec, SourceSpec<CobolPreprocessor.Copybook> cobol) {
        ThrowingConsumer userSuppliedAfterRecipe = cobol.getAfterRecipe();
        cobol.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        Assertions.isCopybookFullyParsed().andThen(spec).accept(cobol);
    }

    public static Consumer<SourceSpec<CobolPreprocessor.Copybook>> isCopybookFullyParsed() {
        return spec -> spec.afterRecipe(cu -> new CobolPreprocessorIsoVisitor<Integer>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                String whitespace = space.getWhitespace().trim();
                if (!IbmAnsi85.getInstance().getSeparators().contains(whitespace + " ") && !whitespace.isEmpty()) {
                    return space.withWhitespace("(~~>" + whitespace + "<~~)");
                }
                return super.visitSpace(space, loc, integer);
            }
        }.visit((Tree)cu, 0));
    }

    public static SourceSpecs cobol(@Nullable String before) {
        return Assertions.cobol(before, (SourceSpec<Cobol.CompilationUnit> s) -> {});
    }

    public static SourceSpecs cobol(@Nullable String before, Consumer<SourceSpec<Cobol.CompilationUnit>> spec) {
        List<SourceFile> copybooks = Assertions.getCopybookSources();
        SourceSpec cobol = new SourceSpec(Cobol.CompilationUnit.class, null, (Parser.Builder)CobolParser.builder().copybooks(copybooks), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        Assertions.acceptSpec(spec, (SourceSpec<Cobol.CompilationUnit>)cobol);
        return cobol;
    }

    public static SourceSpecs cobol(@Nullable String before, @Nullable String after) {
        return Assertions.cobol(before, after, spec -> {});
    }

    public static SourceSpecs cobol(@Nullable String before, @Nullable String after, Consumer<SourceSpec<Cobol.CompilationUnit>> spec) {
        List<SourceFile> copybooks = Assertions.getCopybookSources();
        SourceSpec cobol = new SourceSpec(Cobol.CompilationUnit.class, null, (Parser.Builder)CobolParser.builder().copybooks(copybooks), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext).after(s -> after);
        Assertions.acceptSpec(spec, (SourceSpec<Cobol.CompilationUnit>)cobol);
        return cobol;
    }

    public static SourceSpecs cobolPostProcess(@Nullable String before) {
        return Assertions.cobolPostProcess(before, null);
    }

    public static SourceSpecs cobolPostProcess(@Nullable String before, @Nullable String after) {
        return Assertions.cobolPostProcess(before, after, s -> {});
    }

    public static SourceSpecs cobolPostProcess(@Nullable String before, @Nullable String after, Consumer<SourceSpec<Cobol.CompilationUnit>> spec) {
        List<SourceFile> copybooks = Assertions.getCopybookSources();
        SourceSpec cobol = new SourceSpec(Cobol.CompilationUnit.class, null, (Parser.Builder)CobolParser.builder().copybooks(copybooks), before, SourceSpec.ValidateSource.noop, Assertions::customizeExecutionContext);
        Assertions.isFullyParsed().andThen(Assertions.isPostProcessedLst(after)).andThen(spec).accept((SourceSpec<Cobol.CompilationUnit>)cobol);
        return cobol;
    }

    private static void acceptSpec(Consumer<SourceSpec<Cobol.CompilationUnit>> spec, SourceSpec<Cobol.CompilationUnit> cobol) {
        ThrowingConsumer userSuppliedAfterRecipe = cobol.getAfterRecipe();
        cobol.afterRecipe(((Consumer)userSuppliedAfterRecipe)::accept);
        Assertions.isFullyParsed().andThen(spec).accept(cobol);
    }

    public static Consumer<SourceSpec<Cobol.CompilationUnit>> isFullyParsed() {
        return spec -> spec.afterRecipe(cu -> new CobolPreprocessorIsoVisitor<Integer>(){

            @Override
            public Space visitSpace(Space space, Space.Location loc, Integer integer) {
                String whitespace = space.getWhitespace().trim();
                if (!IbmAnsi85.getInstance().getSeparators().contains(whitespace + " ") && !whitespace.isEmpty()) {
                    return space.withWhitespace("(~~>" + whitespace + "<~~)");
                }
                return super.visitSpace(space, loc, integer);
            }
        }.visit((Tree)cu, 0));
    }

    public static Consumer<SourceSpec<Cobol.CompilationUnit>> isPostProcessedLst(@Nullable String expectedLst) {
        return spec -> spec.afterRecipe(cu -> {
            CobolPrinter printer = new CobolPrinter(false, false);
            PrintOutputCapture outputCapture = new PrintOutputCapture((Object)new InMemoryExecutionContext());
            printer.visit((Tree)cu, outputCapture);
            if (expectedLst != null && !Assertions.trimTrailingSpaces(StringUtils.trimIndentPreserveCRLF((String)outputCapture.getOut())).equals(expectedLst)) {
                System.out.println("Expected LST of length " + expectedLst.length() + ":");
                System.out.println(expectedLst);
                System.out.println("Actual LST of length " + Assertions.trimTrailingSpaces(StringUtils.trimIndentPreserveCRLF((String)outputCapture.getOut())).length() + ":");
                System.out.println(outputCapture.getOut());
            }
            assert (expectedLst == null || Assertions.trimTrailingSpaces(StringUtils.trimIndentPreserveCRLF((String)outputCapture.getOut())).equals(expectedLst));
        });
    }

    public static String trimTrailingSpaces(String input) {
        String[] lines;
        StringBuilder result = new StringBuilder();
        for (String line : lines = input.split("\\r?\\n")) {
            String trimmedLine = line.replaceAll("\\s+$", "");
            result.append(trimmedLine).append("\n");
        }
        return result.toString();
    }

    private static List<SourceFile> getCopybookSources() {
        try (ScanResult scan = new ClassGraph().scan();){
            List<Parser.Input> copyInputs = scan.getResourcesWithExtension("cpy").stream().map(res -> new Parser.Input(Paths.get(res.getPath(), new String[0]), () -> {
                try {
                    return new ByteArrayInputStream(res.getContentAsString().getBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            })).collect(Collectors.toList());
            List<SourceFile> list = CopybookParser.builder().build().parseInputs(copyInputs, null, (ExecutionContext)new InMemoryExecutionContext()).collect(Collectors.toList());
            return list;
        }
    }
}

