/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import org.openrewrite.cobol.CobolStringUtils;
import org.openrewrite.cobol.internal.CobolDialect;

public class CobolLineReader {
    private static final List<String> triggersStart = Arrays.asList("AUTHOR", "INSTALLATION", "DATE-WRITTEN", "DATE-COMPILED", "SECURITY", "REMARKS");
    private static final List<String> triggersEnd = Arrays.asList("PROGRAM-ID", "AUTHOR", "INSTALLATION", "DATE-WRITTEN", "DATE-COMPILED", "SECURITY", "IDENTIFICATION", "ID", "ENVIRONMENT", "DATA", "PROCEDURE", "END");
    private boolean inCommentEntry = false;

    public String readLines(String source, CobolDialect cobolDialect) {
        int indicatorArea = cobolDialect.getColumns().getIndicatorArea();
        int contentAreaAStart = cobolDialect.getColumns().getContentArea();
        int contentAreaBEnd = cobolDialect.getColumns().getOtherArea();
        StringBuilder processedSource = new StringBuilder();
        boolean inLiteralOrHexnumber = false;
        int previousNewLineLength = 0;
        int trailingWhitespaceLength = 0;
        int cursor = 0;
        Scanner scanner = new Scanner(source);
        while (scanner.hasNextLine()) {
            boolean isCommentLine;
            String line = scanner.nextLine();
            if (CobolStringUtils.isSubstituteCharacter(line)) {
                processedSource.append(line);
                continue;
            }
            String indicator = line.length() < indicatorArea + 1 ? "" : (line.length() == indicatorArea + 1 ? line.substring(indicatorArea) : line.substring(indicatorArea, contentAreaAStart));
            String contentArea = line.length() < contentAreaAStart + 1 ? "" : (line.length() == contentAreaAStart + 1 ? line.substring(contentAreaAStart) : line.substring(contentAreaAStart, Math.min(line.length(), contentAreaBEnd)));
            boolean isValidText = !" ".equals(indicator) || !contentArea.trim().isEmpty();
            boolean bl = isCommentLine = !indicator.isEmpty() && cobolDialect.getCommentIndicators().contains(Character.valueOf(indicator.charAt(0)));
            if (this.inCommentEntry && !line.isEmpty()) {
                if (CobolLineReader.startsWithTrigger(contentArea, triggersEnd)) {
                    this.inCommentEntry = false;
                } else {
                    processedSource.append("*>CE ");
                }
            }
            if (!isCommentLine && CobolLineReader.startsWithTrigger(contentArea, triggersStart)) {
                this.inCommentEntry = true;
                String firstWords = CobolLineReader.getFirstWords(contentArea);
                if (!contentArea.substring(firstWords.length()).trim().isEmpty()) {
                    contentArea = firstWords + " *>CE " + contentArea.substring(firstWords.length());
                }
            }
            if (!this.inCommentEntry && isCommentLine) {
                processedSource.append("*> ");
            }
            if (isValidText) {
                String trimmedContentArea = CobolStringUtils.trimLeadingWhitespace(contentArea);
                if ("-".equals(indicator)) {
                    if (trimmedContentArea.startsWith("\"") || trimmedContentArea.startsWith("'")) {
                        if (inLiteralOrHexnumber) {
                            processedSource.delete(processedSource.length() - previousNewLineLength, processedSource.length());
                            trimmedContentArea = CobolStringUtils.trimLeadingChar(trimmedContentArea);
                        } else {
                            inLiteralOrHexnumber = true;
                        }
                    } else {
                        processedSource.delete(processedSource.length() - previousNewLineLength, processedSource.length());
                        processedSource.delete(processedSource.length() - trailingWhitespaceLength, processedSource.length());
                        inLiteralOrHexnumber = CobolLineReader.startOfLiteralOrHexNumber(trimmedContentArea);
                    }
                    processedSource.append(trimmedContentArea);
                } else {
                    inLiteralOrHexnumber = CobolLineReader.startOfLiteralOrHexNumber(trimmedContentArea);
                    processedSource.append(contentArea);
                }
            }
            trailingWhitespaceLength = contentArea.length() - CobolStringUtils.trimTrailingWhitespace(contentArea).length();
            String endOfLine = source.substring(cursor += line.length()).startsWith("\r\n") ? "\r\n" : (source.substring(cursor).startsWith("\n") ? "\n" : null);
            int n = previousNewLineLength = endOfLine == null ? 0 : endOfLine.length();
            if (endOfLine == null) continue;
            cursor += endOfLine.length();
            if (!this.inCommentEntry && !isValidText) continue;
            processedSource.append(endOfLine);
        }
        return processedSource.toString();
    }

    private static boolean startOfLiteralOrHexNumber(String contentArea) {
        int ticks = 0;
        int quotes = 0;
        for (char c : contentArea.toCharArray()) {
            if (c == '\'') {
                ++ticks;
                continue;
            }
            if (c != '\"') continue;
            ++quotes;
        }
        return ticks % 2 != 0 || quotes % 2 != 0 || contentArea.endsWith("'") || contentArea.endsWith("\"");
    }

    private static String getFirstWords(String line) {
        char c;
        int i;
        char[] charArray = line.toCharArray();
        for (i = 0; i < charArray.length && !Character.isWhitespace(c = charArray[i]); ++i) {
        }
        return line.substring(0, i);
    }

    private static boolean startsWithTrigger(String line, List<String> triggers) {
        String firstWordsUpper = CobolLineReader.getFirstWords(line).toUpperCase();
        boolean isTrigger = false;
        for (String trigger : triggers) {
            if (!firstWordsUpper.equals(trigger) && !firstWordsUpper.startsWith(trigger + ".")) continue;
            isTrigger = true;
            break;
        }
        return isTrigger;
    }
}

