/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.cobol;

import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATN;
import org.antlr.v4.runtime.atn.ATNConfig;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionContextCache;
import org.antlr.v4.runtime.dfa.DFA;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.cobol.CobolParsingException;
import org.openrewrite.cobol.CobolParsingTimeoutException;
import org.openrewrite.cobol.CobolPreprocessorParser;
import org.openrewrite.cobol.internal.CobolDialect;
import org.openrewrite.cobol.internal.CobolParserVisitor;
import org.openrewrite.cobol.internal.CobolPreprocessorOutputSourcePrinter;
import org.openrewrite.cobol.internal.grammar.CobolLexer;
import org.openrewrite.cobol.internal.grammar.CobolParser;
import org.openrewrite.cobol.tree.Cobol;
import org.openrewrite.cobol.tree.CobolPreprocessor;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class CobolParser
implements Parser {
    public static final List<String> COPYBOOK_FILE_EXTENSIONS = Collections.singletonList(".cpy");
    public static final List<String> COBOL_FILE_EXTENSIONS = Collections.singletonList(".cbl");
    private final CobolDialect cobolDialect;
    private final List<SourceFile> copybooks;
    private final Duration timeout;

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sourceFiles, @Nullable Path relativeTo, ExecutionContext ctx) {
        CobolPreprocessorParser cobolPreprocessorParser = CobolPreprocessorParser.builder().cobolDialect(this.cobolDialect).copybooks(this.copybooks).build();
        return this.acceptedInputs(sourceFiles).map(s -> this.parseInput((Parser.Input)s, relativeTo, ctx, cobolPreprocessorParser));
    }

    private SourceFile parseInput(Parser.Input input, @Nullable Path relativeTo, ExecutionContext ctx, CobolPreprocessorParser cobolPreprocessorParser) {
        ParsingEventListener parserListener = ParsingExecutionContextView.view((ExecutionContext)ctx).getParsingListener();
        try {
            parserListener.startedParsing(input);
            EncodingDetectingInputStream is = input.getSource(ctx);
            cobolPreprocessorParser.reset();
            SourceFile preprocessedCU = (SourceFile)cobolPreprocessorParser.parseInputs(Collections.singletonList(input), relativeTo, ctx).collect(Collectors.toList()).get(0);
            assert (preprocessedCU != null);
            if (preprocessedCU instanceof ParseError) {
                return preprocessedCU;
            }
            PrintOutputCapture cobolParserOutput = new PrintOutputCapture((Object)new InMemoryExecutionContext());
            CobolPreprocessorOutputSourcePrinter printWithoutColumns = new CobolPreprocessorOutputSourcePrinter(this.cobolDialect, false);
            printWithoutColumns.visit((Tree)preprocessedCU, cobolParserOutput);
            org.openrewrite.cobol.internal.grammar.CobolParser parser = new org.openrewrite.cobol.internal.grammar.CobolParser((TokenStream)new CommonTokenStream((TokenSource)new CobolLexer((CharStream)CharStreams.fromString((String)cobolParserOutput.getOut())))){
                {
                    this._interp = new TimeLimitingParserATNSimulator(this, _ATN, _decisionToDFA, _sharedContextCache);
                }
            };
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new ForwardingErrorListener(input.getPath(), ctx));
            PrintOutputCapture sourceOutput = new PrintOutputCapture((Object)new InMemoryExecutionContext());
            CobolPreprocessorOutputSourcePrinter printWithColumns = new CobolPreprocessorOutputSourcePrinter(this.cobolDialect, true);
            printWithColumns.visit((Tree)preprocessedCU, sourceOutput);
            try {
                CobolParser.CompilationUnitContext tokenizedCU = parser.compilationUnit();
                Cobol.CompilationUnit compilationUnit = new CobolParserVisitor(input.getRelativePath(relativeTo), input.getFileAttributes(), sourceOutput.getOut(), is.getCharset(), is.isCharsetBomMarked(), this.cobolDialect, ((CobolPreprocessor.CompilationUnit)preprocessedCU).getPreprocessorStatements(), ((CobolPreprocessor.CompilationUnit)preprocessedCU).getReplacements(), this.timeout).visitCompilationUnit(tokenizedCU);
                parserListener.parsed(input, (SourceFile)compilationUnit);
                return compilationUnit;
            }
            catch (ParseCancellationException e) {
                throw new CobolParsingTimeoutException(relativeTo == null ? input.getPath() : relativeTo.relativize(input.getPath()));
            }
        }
        catch (Throwable t) {
            ctx.getOnError().accept(t);
            return ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)t);
        }
    }

    public boolean accept(Path path) {
        String s = path.toString().toLowerCase();
        for (String COBOL_FILE_EXTENSION : COBOL_FILE_EXTENSIONS) {
            if (!s.endsWith(COBOL_FILE_EXTENSION)) continue;
            return true;
        }
        for (String COPYBOOK_FILE_EXTENSION : COPYBOOK_FILE_EXTENSIONS) {
            if (!s.endsWith(COPYBOOK_FILE_EXTENSION)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.CBL");
    }

    public static Builder builder() {
        return new Builder();
    }

    public CobolParser(CobolDialect cobolDialect, List<SourceFile> copybooks, Duration timeout) {
        this.cobolDialect = cobolDialect;
        this.copybooks = copybooks;
        this.timeout = timeout;
    }

    private static class ForwardingErrorListener
    extends BaseErrorListener {
        private final Path sourcePath;
        private final ExecutionContext ctx;

        private ForwardingErrorListener(Path sourcePath, ExecutionContext ctx) {
            this.sourcePath = sourcePath;
            this.ctx = ctx;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            this.ctx.getOnError().accept(new CobolParsingException(this.sourcePath, String.format("Syntax error in %s at line %d:%d %s.", this.sourcePath, line, charPositionInLine, msg), (Throwable)e));
        }
    }

    public static class Builder
    extends Parser.Builder {
        private CobolDialect cobolDialect = CobolDialect.ibmAnsi85();
        private List<SourceFile> copybooks = Collections.emptyList();
        private Duration timeout = Duration.ofSeconds(10L);

        public Builder() {
            super(Cobol.CompilationUnit.class);
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder cobolDialect(CobolDialect cobolDialect) {
            this.cobolDialect = cobolDialect;
            return this;
        }

        public Builder copybooks(List<SourceFile> copybooks) {
            this.copybooks = copybooks;
            return this;
        }

        public CobolParser build() {
            return new CobolParser(this.cobolDialect, this.copybooks, this.timeout);
        }

        public String getDslName() {
            return "cobol";
        }
    }

    private class TimeLimitingParserATNSimulator
    extends ParserATNSimulator {
        private final Instant start;

        public TimeLimitingParserATNSimulator(org.antlr.v4.runtime.Parser parser, ATN atn, DFA[] decisionToDFA, PredictionContextCache sharedContextCache) {
            super(parser, atn, decisionToDFA, sharedContextCache);
            this.start = Instant.now();
        }

        protected void closure(ATNConfig config, ATNConfigSet configs, Set<ATNConfig> closureBusy, boolean collectPredicates, boolean fullCtx, boolean treatEofAsEpsilon) {
            Duration timeElapsed = Duration.between(this.start, Instant.now());
            if (timeElapsed.compareTo(CobolParser.this.timeout) > 0) {
                throw new ParseCancellationException();
            }
            super.closure(config, configs, closureBusy, collectPredicates, fullCtx, treatEofAsEpsilon);
        }
    }
}

